/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlowConsumerTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)SlowConsumerTest.class);
    private Socket stompSocket;
    private ByteArrayOutputStream inputBuffer;
    private static final int MESSAGES_COUNT = 10000;
    private int messagesCount;
    protected int messageLogFrequency = 2500;
    protected long messageReceiveTimeout = 10000L;

    public void testRemoveSubscriber() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(true);
        broker.setUseJmx(true);
        broker.addConnector("tcp://localhost:61616").setName("Default");
        broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        final Connection connection = factory.createConnection();
        connection.start();
        Thread producingThread = new Thread("Producing thread"){

            public void run() {
                try {
                    Session session = connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(SlowConsumerTest.this.getDestinationName()));
                    for (int idx = 0; idx < 10000; ++idx) {
                        TextMessage message = session.createTextMessage("" + idx);
                        producer.send((Message)message);
                        log.debug((Object)("Sending: " + idx));
                    }
                    producer.close();
                    session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.setPriority(10);
        producingThread.start();
        Thread.sleep(1000L);
        Thread consumingThread = new Thread("Consuming thread"){

            public void run() {
                try {
                    Session session = connection.createSession(false, 2);
                    MessageConsumer consumer = session.createConsumer((Destination)new ActiveMQQueue(SlowConsumerTest.this.getDestinationName()));
                    int diff = 0;
                    while (SlowConsumerTest.this.messagesCount != 10000) {
                        Message msg = consumer.receive(SlowConsumerTest.this.messageReceiveTimeout);
                        if (msg == null) {
                            log.warn((Object)("Got null message at count: " + SlowConsumerTest.this.messagesCount + ". Continuing..."));
                            break;
                        }
                        String text = ((TextMessage)msg).getText();
                        int currentMsgIdx = Integer.parseInt(text);
                        log.debug((Object)("Received: " + text + " messageCount: " + SlowConsumerTest.this.messagesCount));
                        msg.acknowledge();
                        if (SlowConsumerTest.this.messagesCount + diff != currentMsgIdx) {
                            log.debug((Object)("Message(s) skipped!! Should be message no.: " + SlowConsumerTest.this.messagesCount + " but got: " + currentMsgIdx));
                            diff = currentMsgIdx - SlowConsumerTest.this.messagesCount;
                        }
                        ++SlowConsumerTest.this.messagesCount;
                        if (SlowConsumerTest.this.messagesCount % SlowConsumerTest.this.messageLogFrequency != 0) continue;
                        log.info((Object)("Received: " + SlowConsumerTest.this.messagesCount + " messages so far"));
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        consumingThread.start();
        consumingThread.join();
        SlowConsumerTest.assertEquals((int)10000, (int)this.messagesCount);
    }

    public void sendFrame(String data) throws Exception {
        byte[] bytes = data.getBytes("UTF-8");
        OutputStream outputStream = this.stompSocket.getOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            outputStream.write(bytes[i]);
        }
        outputStream.flush();
    }

    public String receiveFrame(long timeOut) throws Exception {
        this.stompSocket.setSoTimeout((int)timeOut);
        InputStream is = this.stompSocket.getInputStream();
        int c = 0;
        while (true) {
            if ((c = is.read()) < 0) {
                throw new IOException("socket closed.");
            }
            if (c == 0) {
                c = is.read();
                byte[] ba = this.inputBuffer.toByteArray();
                this.inputBuffer.reset();
                return new String(ba, "UTF-8");
            }
            this.inputBuffer.write(c);
        }
    }

    protected String getDestinationName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

