/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;

public class RoundRobinDispatchPolicyTest
extends QueueSubscriptionTest {
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy((DispatchPolicy)new RoundRobinDispatchPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesOnePrefetch();
        this.assertEachConsumerReceivedAtLeastXMessages(1);
    }

    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesLargePrefetch();
        this.assertMessagesDividedAmongConsumers();
    }

    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesOnePrefetch();
        this.assertEachConsumerReceivedAtLeastXMessages(1);
    }

    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesLargePrefetch();
        this.assertMessagesDividedAmongConsumers();
    }

    public void testOneProducerManyConsumersFewMessages() throws Exception {
        super.testOneProducerManyConsumersFewMessages();
        this.assertMessagesDividedAmongConsumers();
    }

    public void testOneProducerManyConsumersManyMessages() throws Exception {
        super.testOneProducerManyConsumersManyMessages();
        this.assertMessagesDividedAmongConsumers();
    }

    public void testManyProducersManyConsumers() throws Exception {
        super.testManyProducersManyConsumers();
        this.assertMessagesDividedAmongConsumers();
    }

    public void assertMessagesDividedAmongConsumers() {
        this.assertEachConsumerReceivedAtLeastXMessages(this.messageCount * this.producerCount / this.consumerCount);
        this.assertEachConsumerReceivedAtMostXMessages(this.messageCount * this.producerCount / this.consumerCount + 1);
    }
}

