/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;

public class RecoveryBrokerTest
extends BrokerRestartTestSupport {
    public void testConsumedQueuePersistentMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            connection.send((Command)message);
        }
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m2 = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m2);
        }
        this.restartBroker();
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testQueuePersistentUncommitedMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            message.setTransactionId((TransactionId)txid);
            connection.send((Command)message);
        }
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testTopicDurableConsumerHoldsPersistentMessageAfterRestart() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("A");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setSubscriptionName("test");
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        connection1.send((Command)this.closeConsumerInfo(consumerInfo1));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        this.restartBroker();
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        connectionInfo2.setClientId("A");
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setSubscriptionName("test");
        consumerInfo2.setPrefetchSize(100);
        connection2.send((Command)consumerInfo2);
        for (int i = 0; i < 4; ++i) {
            Message m2 = this.receiveMessage(connection2);
            RecoveryBrokerTest.assertNotNull((Object)m2);
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void testQueuePersistentMessagesNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
        message.setPersistent(true);
        connection.send((Command)message);
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNotNull((String)"Should have received a message by now!", (Object)m);
        RecoveryBrokerTest.assertEquals((Object)m.getMessageId(), (Object)message.getMessageId());
    }

    public void testQueueNonPersistentMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
        message.setPersistent(false);
        connection.send((Command)message);
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedMessagesNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            message.setTransactionId((TransactionId)txid);
            connection.send((Command)message);
        }
        connection.send((Command)this.createCommitTransaction1Phase(connectionInfo, (TransactionId)txid));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedAcksNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            connection.send((Command)message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId((TransactionId)txid);
            connection.send((Command)ack);
        }
        connection.send((Command)this.createCommitTransaction1Phase(connectionInfo, (TransactionId)txid));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testQueuePersistentUncommitedAcksLostOnRestart() throws Exception {
        Message m;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        for (int i2 = 0; i2 < 4; ++i2) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
            message.setPersistent(true);
            connection.send((Command)message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId((TransactionId)txid);
            connection.send((Command)ack);
        }
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, (ActiveMQDestination)destination);
        connection.send((Command)consumerInfo);
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public static Test suite() {
        return RecoveryBrokerTest.suite(RecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RecoveryBrokerTest.suite());
    }
}

