/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.activemq.AutoFailTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CombinationTestSupport
extends AutoFailTestSupport {
    protected static final Log log = LogFactory.getLog((Class)CombinationTestSupport.class);
    private HashMap comboOptions = new HashMap();
    private boolean combosEvaluated;
    private Map options;

    public void addCombinationValues(String attribute, Object[] options) {
        ComboOption co = (ComboOption)this.comboOptions.get(attribute);
        if (co == null) {
            this.comboOptions.put(attribute, new ComboOption(attribute, Arrays.asList(options)));
        } else {
            co.values.addAll(Arrays.asList(options));
        }
    }

    public void runBare() throws Throwable {
        if (this.combosEvaluated) {
            super.runBare();
        } else {
            CombinationTestSupport[] combinations = this.getCombinations();
            for (int i = 0; i < combinations.length; ++i) {
                CombinationTestSupport test = combinations[i];
                log.info((Object)("Running " + test.getName()));
                test.runBare();
            }
        }
    }

    private void setOptions(Map options) throws NoSuchFieldException, IllegalAccessException {
        this.options = options;
        Iterator iterator = options.keySet().iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            Object value = options.get(attribute);
            try {
                Field field = ((Object)((Object)this)).getClass().getField(attribute);
                field.set((Object)this, value);
            }
            catch (Throwable e) {
                log.info((Object)("Could not set field '" + attribute + "' to value '" + value + "', make sure the field exists and is public."));
            }
        }
    }

    private CombinationTestSupport[] getCombinations() {
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod("initCombos", null);
            method.invoke((Object)this, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        String name = this.getName();
        String comboSetupMethodName = "initCombosFor" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(comboSetupMethodName, null);
            method.invoke((Object)this, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ArrayList expandedOptions = new ArrayList();
            this.expandCombinations(new ArrayList(this.comboOptions.values()), expandedOptions);
            if (expandedOptions.isEmpty()) {
                this.combosEvaluated = true;
                return new CombinationTestSupport[]{this};
            }
            ArrayList<CombinationTestSupport> result = new ArrayList<CombinationTestSupport>();
            Iterator iter = expandedOptions.iterator();
            while (iter.hasNext()) {
                CombinationTestSupport combo = (CombinationTestSupport)TestSuite.createTest(((Object)((Object)this)).getClass(), (String)this.getName());
                combo.combosEvaluated = true;
                combo.setOptions((Map)iter.next());
                result.add(combo);
            }
            CombinationTestSupport[] rc = new CombinationTestSupport[result.size()];
            result.toArray(rc);
            return rc;
        }
        catch (Throwable e) {
            this.combosEvaluated = true;
            return new CombinationTestSupport[]{this};
        }
    }

    private void expandCombinations(List optionsLeft, List expandedCombos) {
        if (!optionsLeft.isEmpty()) {
            HashMap map;
            if (this.comboOptions.size() == optionsLeft.size()) {
                map = new HashMap();
                expandedCombos.add(map);
            } else {
                map = (HashMap)expandedCombos.get(expandedCombos.size() - 1);
            }
            LinkedList l = new LinkedList(optionsLeft);
            ComboOption comboOption = (ComboOption)l.removeLast();
            int i = 0;
            Iterator iter = comboOption.values.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (i != 0) {
                    map = new HashMap(map);
                    expandedCombos.add(map);
                }
                map.put(comboOption.attribute, value);
                this.expandCombinations(l, expandedCombos);
                ++i;
            }
        }
    }

    public static Test suite(Class clazz) {
        TestSuite suite = new TestSuite();
        ArrayList<String> names = new ArrayList<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (names.contains(name) || !CombinationTestSupport.isPublicTestMethod(methods[i])) continue;
            names.add(name);
            Test test = TestSuite.createTest((Class)clazz, (String)name);
            if (test instanceof CombinationTestSupport) {
                CombinationTestSupport[] combinations = ((CombinationTestSupport)test).getCombinations();
                for (int j = 0; j < combinations.length; ++j) {
                    suite.addTest((Test)combinations[j]);
                }
                continue;
            }
            suite.addTest(test);
        }
        return suite;
    }

    private static boolean isPublicTestMethod(Method m) {
        return CombinationTestSupport.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private static boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public String getName() {
        if (this.options != null) {
            return super.getName() + " " + this.options;
        }
        return super.getName();
    }

    static class ComboOption {
        final String attribute;
        final LinkedHashSet values = new LinkedHashSet();

        public ComboOption(String attribute, Collection options) {
            this.attribute = attribute;
            this.values.addAll(options);
        }
    }
}

