/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class ActiveMQConnectionFactoryTest
extends CombinationTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseURIToSetUseClientIDPrefixOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?jms.clientIDPrefix=Cheese");
        ActiveMQConnectionFactoryTest.assertEquals((String)"Cheese", (String)cf.getClientIDPrefix());
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        try {
            connection.start();
            String clientID = connection.getClientID();
            log.info((Object)("Got client ID: " + clientID));
            ActiveMQConnectionFactoryTest.assertTrue((String)("should start with Cheese! but was: " + clientID), (boolean)clientID.startsWith("Cheese"));
        }
        finally {
            connection.close();
        }
    }

    public void testUseURIToSetOptionsOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?jms.useAsyncSend=true");
        ActiveMQConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQConnectionFactory("vm://localhost?jms.useAsyncSend=false");
        ActiveMQConnectionFactoryTest.assertFalse((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQConnectionFactory("vm:(broker:()/localhost)?jms.useAsyncSend=true");
        ActiveMQConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQConnectionFactoryTest.assertEquals((String)"vm:(broker:()/localhost)", (String)cf.getBrokerURL());
    }

    public void testCreateVMConnectionWithEmbdeddBroker() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        Connection connection = cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)connection);
        ActiveMQConnectionFactoryTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        connection.close();
        ActiveMQConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
    }

    public void testGetBrokerName() throws URISyntaxException, JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        String brokerName = connection.getBrokerName();
        log.info((Object)("Got broker name: " + brokerName));
        ActiveMQConnectionFactoryTest.assertNotNull((String)"No broker name available!", (Object)brokerName);
        connection.close();
    }

    public void testCreateTcpConnectionUsingAllocatedPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testConnectionFailsToConnectToVMBrokerThatIsNotRunning() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        try {
            factory.createConnection();
            ActiveMQConnectionFactoryTest.fail((String)"Expected connection failure.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testFactorySerializable() throws Exception {
        String clientID = "TestClientID";
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        cf.setClientID(clientID);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objectsOut = new ObjectOutputStream(bytesOut);
        objectsOut.writeObject(cf);
        objectsOut.flush();
        byte[] data = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
        ObjectInputStream objectsIn = new ObjectInputStream(bytesIn);
        cf = (ActiveMQConnectionFactory)objectsIn.readObject();
        ActiveMQConnectionFactoryTest.assertEquals((String)cf.getClientID(), (String)clientID);
    }

    protected void assertCreateConnection(String uri) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        TransportConnector connector = broker.addConnector(uri);
        broker.start();
        URI temp = new URI(uri);
        URI currentURI = connector.getServer().getConnectURI();
        URI connectURI = new URI(temp.getScheme(), temp.getUserInfo(), temp.getHost(), currentURI.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
        log.info((Object)("connection URI is: " + connectURI));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(connectURI);
        Connection connection = cf.createConnection();
        ActiveMQConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        broker.stop();
    }
}

