/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;

public class ArrayElementValueGen
extends ElementValueGen {
    private List evalues;

    public ArrayElementValueGen(ConstantPoolGen constantPoolGen) {
        super(91, constantPoolGen);
        this.evalues = new ArrayList();
    }

    public ArrayElementValueGen(int n, ElementValue[] elementValueArray, ConstantPoolGen constantPoolGen) {
        super(n, constantPoolGen);
        if (n != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = new ArrayList();
        for (int i = 0; i < elementValueArray.length; ++i) {
            this.evalues.add(elementValueArray[i]);
        }
    }

    public ElementValue getElementValue() {
        ElementValue[] elementValueArray = new ElementValue[this.evalues.size()];
        int n = 0;
        for (ElementValueGen elementValueGen : this.evalues) {
            elementValueArray[n++] = elementValueGen.getElementValue();
        }
        return new ArrayElementValue(this.type, elementValueArray, this.cpGen.getConstantPool());
    }

    public ArrayElementValueGen(ArrayElementValue arrayElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(91, constantPoolGen);
        this.evalues = new ArrayList();
        ElementValue[] elementValueArray = arrayElementValue.getElementValuesArray();
        for (int i = 0; i < elementValueArray.length; ++i) {
            this.evalues.add(ElementValueGen.copy(elementValueArray[i], constantPoolGen, bl));
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.evalues.size());
        for (ElementValueGen elementValueGen : this.evalues) {
            elementValueGen.dump(dataOutputStream);
        }
    }

    public String stringifyValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.evalues.iterator();
        while (iterator.hasNext()) {
            ElementValueGen elementValueGen = (ElementValueGen)iterator.next();
            stringBuffer.append(elementValueGen.stringifyValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public List getElementValues() {
        return this.evalues;
    }

    public int getElementValuesSize() {
        return this.evalues.size();
    }

    public void addElement(ElementValueGen elementValueGen) {
        this.evalues.add(elementValueGen);
    }
}

