/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;

public class EnumElementValue
extends ElementValue {
    private int typeIdx;
    private int valueIdx;

    public EnumElementValue(int n, int n2, int n3, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor");
        }
        this.typeIdx = n2;
        this.valueIdx = n3;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.typeIdx);
        dataOutputStream.writeShort(this.valueIdx);
    }

    public String stringifyValue() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.valueIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public String getEnumTypeString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public String getEnumValueString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.valueIdx, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

