/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public abstract class Annotations
extends Attribute {
    private int annotation_table_length;
    private AnnotationEntry[] annotation_table;
    private boolean isRuntimeVisible;

    public Annotations(byte by, int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        this(by, n, n2, (AnnotationEntry[])null, constantPool, bl);
        this.annotation_table_length = dataInputStream.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[this.annotation_table_length];
        for (int i = 0; i < this.annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(dataInputStream, constantPool, bl);
        }
    }

    public Annotations(byte by, int n, int n2, AnnotationEntry[] annotationEntryArray, ConstantPool constantPool, boolean bl) {
        super(by, n, n2, constantPool);
        this.setAnnotationTable(annotationEntryArray);
        this.isRuntimeVisible = bl;
    }

    public void accept(Visitor visitor) {
        visitor.visitAnnotation(this);
    }

    public final void setAnnotationTable(AnnotationEntry[] annotationEntryArray) {
        this.annotation_table = annotationEntryArray;
        this.annotation_table_length = annotationEntryArray == null ? 0 : annotationEntryArray.length;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final int getNumAnnotations() {
        return this.annotation_table_length;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.annotation_table_length);
        for (int i = 0; i < this.annotation_table_length; ++i) {
            this.annotation_table[i].dump(dataOutputStream);
        }
    }
}

