/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualTopicInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class VirtualTopic
implements VirtualDestination {
    private String prefix = "Consumer.*.";
    private String postfix = "";
    private String name = ">";

    public ActiveMQDestination getVirtualDestination() {
        return new ActiveMQTopic(this.getName());
    }

    public Destination intercept(Destination destination) {
        return new VirtualTopicInterceptor(destination, this.getPrefix(), this.getPostfix());
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected ActiveMQDestination getQueueConsumersWildcard(ActiveMQDestination original) {
        return new ActiveMQQueue(this.prefix + original.getPhysicalName() + this.postfix);
    }
}

