/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import java.util.Collection;
import java.util.Iterator;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;

public class CompositeDestinationInterceptor
extends DestinationFilter {
    private Collection forwardDestinations;
    private boolean forwardOnly;
    private boolean copyMessage;

    public CompositeDestinationInterceptor(Destination next, Collection forwardDestinations, boolean forwardOnly, boolean copyMessage) {
        super(next);
        this.forwardDestinations = forwardDestinations;
        this.forwardOnly = forwardOnly;
        this.copyMessage = copyMessage;
    }

    public void send(ConnectionContext context, Message message) throws Exception {
        Iterator iter = this.forwardDestinations.iterator();
        while (iter.hasNext()) {
            ActiveMQDestination destination = (ActiveMQDestination)iter.next();
            if (this.copyMessage) {
                message = message.copy();
                message.setDestination(destination);
            }
            this.send(context, message, destination);
        }
        if (!this.forwardOnly) {
            super.send(context, message);
        }
    }
}

