/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.group;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupSet;
import org.apache.activemq.broker.region.group.SimpleMessageGroupSet;
import org.apache.activemq.command.ConsumerId;

public class SimpleMessageGroupMap
implements MessageGroupMap {
    private Map map = new ConcurrentHashMap();

    public void put(String groupId, ConsumerId consumerId) {
        this.map.put(groupId, consumerId);
    }

    public ConsumerId get(String groupId) {
        return (ConsumerId)this.map.get(groupId);
    }

    public ConsumerId removeGroup(String groupId) {
        return (ConsumerId)this.map.remove(groupId);
    }

    public MessageGroupSet removeConsumer(ConsumerId consumerId) {
        SimpleMessageGroupSet ownedGroups = new SimpleMessageGroupSet();
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            String group = (String)iter.next();
            ConsumerId owner = (ConsumerId)this.map.get(group);
            if (!owner.equals(consumerId)) continue;
            ownedGroups.add(group);
            iter.remove();
        }
        return ownedGroups;
    }

    public String toString() {
        return "message groups: " + this.map.size();
    }
}

