/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.FixedCountSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Topic
implements Destination {
    private static final Log log = LogFactory.getLog((Class)Topic.class);
    protected final ActiveMQDestination destination;
    protected final CopyOnWriteArrayList consumers = new CopyOnWriteArrayList();
    protected final Valve dispatchValve = new Valve(true);
    protected final TopicMessageStore store;
    protected final UsageManager usageManager;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private DispatchPolicy dispatchPolicy = new SimpleDispatchPolicy();
    private SubscriptionRecoveryPolicy subscriptionRecoveryPolicy = new FixedCountSubscriptionRecoveryPolicy();
    private boolean sendAdvisoryIfNoConsumers;
    private DeadLetterStrategy deadLetterStrategy = new SharedDeadLetterStrategy();
    private final ConcurrentHashMap durableSubcribers = new ConcurrentHashMap();

    public Topic(ActiveMQDestination destination, TopicMessageStore store, UsageManager memoryManager, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) {
        this.destination = destination;
        this.store = store;
        this.usageManager = new UsageManager(memoryManager);
        this.usageManager.setLimit(Long.MAX_VALUE);
        if (store != null) {
            store.setUsageManager(this.usageManager);
        }
        this.destinationStatistics.setParent(parentStats);
    }

    public boolean lock(MessageReference node, LockOwner sub) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        if (!sub.getConsumerInfo().isDurable()) {
            if (sub.getConsumerInfo().isRetroactive()) {
                this.dispatchValve.turnOff();
                try {
                    CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        this.consumers.add((Object)sub);
                    }
                    this.subscriptionRecoveryPolicy.recover(context, this, sub);
                }
                finally {
                    this.dispatchValve.turnOn();
                }
            }
            CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.add((Object)sub);
            }
        }
        DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
        this.durableSubcribers.put((Object)dsub.getSubscriptionKey(), (Object)dsub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!sub.getConsumerInfo().isDurable()) {
            this.destinationStatistics.getConsumers().decrement();
            CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.remove((Object)sub);
            }
        }
        sub.remove(context, this);
    }

    public void deleteSubscription(ConnectionContext context, SubscriptionKey key) throws IOException {
        if (this.store != null) {
            this.store.deleteSubscription(key.clientId, key.subscriptionName);
            Object removed = this.durableSubcribers.remove((Object)key);
            if (removed != null) {
                this.destinationStatistics.getConsumers().decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ConnectionContext context, final DurableTopicSubscription subscription) throws Exception {
        this.dispatchValve.turnOff();
        try {
            String s1;
            CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.add((Object)subscription);
            }
            if (this.store == null) {
                return;
            }
            String clientId = subscription.getClientId();
            String subscriptionName = subscription.getSubscriptionName();
            String selector = subscription.getConsumerInfo().getSelector();
            SubscriptionInfo info = this.store.lookupSubscription(clientId, subscriptionName);
            if (info != null && ((s1 = info.getSelector()) == null ^ selector == null || s1 != null && !s1.equals(selector))) {
                this.store.deleteSubscription(clientId, subscriptionName);
                info = null;
            }
            if (info == null) {
                this.store.addSubsciption(clientId, subscriptionName, selector, subscription.getConsumerInfo().isRetroactive());
            }
            final MessageEvaluationContext msgContext = new MessageEvaluationContext();
            msgContext.setDestination(this.destination);
            if (subscription.isRecoveryRequired()) {
                this.store.recoverSubscription(clientId, subscriptionName, new MessageRecoveryListener(){

                    public void recoverMessage(Message message) throws Exception {
                        message.setRegionDestination(Topic.this);
                        try {
                            msgContext.setMessageReference(message);
                            if (subscription.matches(message, msgContext)) {
                                subscription.add(message);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    public void recoverMessageReference(String messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public void finished() {
                    }
                });
            }
            if (subscription.getConsumerInfo().isRetroactive() && subscription.getEnqueueCounter() == 0L) {
                this.subscriptionRecoveryPolicy.recover(context, this, subscription);
            }
        }
        finally {
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(ConnectionContext context, DurableTopicSubscription sub) throws Exception {
        CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            this.consumers.remove((Object)sub);
        }
        sub.remove(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final ConnectionContext context, final Message message) throws Exception {
        if (context.isProducerFlowControl()) {
            if (this.usageManager.isSendFailIfNoSpace() && this.usageManager.isFull()) {
                throw new ResourceAllocationException("Usage Manager memory limit reached");
            }
            this.usageManager.waitForSpace();
        }
        message.setRegionDestination(this);
        if (this.store != null && message.isPersistent() && !this.canOptimizeOutPersistence()) {
            this.store.addMessage(context, message);
        }
        message.incrementReferenceCount();
        try {
            if (context.isInTransaction()) {
                context.getTransaction().addSynchronization(new Synchronization(){

                    public void afterCommit() throws Exception {
                        Topic.this.dispatch(context, message);
                    }
                });
            } else {
                this.dispatch(context, message);
            }
        }
        finally {
            message.decrementReferenceCount();
        }
    }

    private boolean canOptimizeOutPersistence() {
        return this.durableSubcribers.size() == 0;
    }

    public String toString() {
        return "Topic: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size();
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
            this.store.acknowledge(context, dsub.getClientId(), dsub.getSubscriptionName(), node.getMessageId());
        }
    }

    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
        this.destinationStatistics.setParent(null);
    }

    public void gc() {
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        return this.store != null ? this.store.getMessage(messageId) : null;
    }

    public void start() throws Exception {
        this.subscriptionRecoveryPolicy.start();
    }

    public void stop() throws Exception {
        this.subscriptionRecoveryPolicy.stop();
    }

    public Message[] browse() {
        CopyOnWriteArraySet result = new CopyOnWriteArraySet();
        try {
            if (this.store != null) {
                this.store.recover(new MessageRecoveryListener((Set)result){
                    private final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                    }

                    public void recoverMessage(Message message) throws Exception {
                        this.val$result.add(message);
                    }

                    public void recoverMessageReference(String messageReference) throws Exception {
                    }

                    public void finished() {
                    }
                });
                Message[] msgs = this.subscriptionRecoveryPolicy.browse(this.getActiveMQDestination());
                if (msgs != null) {
                    for (int i = 0; i < msgs.length; ++i) {
                        result.add(msgs[i]);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Failed to browse Topic: " + this.getActiveMQDestination().getPhysicalName()), e);
        }
        return result.toArray(new Message[result.size()]);
    }

    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public String getDestination() {
        return this.destination.getPhysicalName();
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public SubscriptionRecoveryPolicy getSubscriptionRecoveryPolicy() {
        return this.subscriptionRecoveryPolicy;
    }

    public void setSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy subscriptionRecoveryPolicy) {
        this.subscriptionRecoveryPolicy = subscriptionRecoveryPolicy;
    }

    public boolean isSendAdvisoryIfNoConsumers() {
        return this.sendAdvisoryIfNoConsumers;
    }

    public void setSendAdvisoryIfNoConsumers(boolean sendAdvisoryIfNoConsumers) {
        this.sendAdvisoryIfNoConsumers = sendAdvisoryIfNoConsumers;
    }

    public MessageStore getMessageStore() {
        return this.store;
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public String getName() {
        return this.getActiveMQDestination().getPhysicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatch(ConnectionContext context, Message message) throws Exception {
        this.destinationStatistics.getEnqueues().increment();
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            if (!this.subscriptionRecoveryPolicy.add(context, message)) {
                return;
            }
            CopyOnWriteArrayList copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                if (this.consumers.isEmpty()) {
                    this.onMessageWithNoConsumers(context, message);
                    return;
                }
            }
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(message);
            if (this.dispatchPolicy.dispatch(context, message, msgContext, (List)this.consumers)) return;
            this.onMessageWithNoConsumers(context, message);
            return;
        }
        finally {
            msgContext.clear();
            this.dispatchValve.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageWithNoConsumers(ConnectionContext context, Message message) throws Exception {
        if (!message.isPersistent() && this.sendAdvisoryIfNoConsumers && !AdvisorySupport.isAdvisoryTopic(this.destination)) {
            if (message.getOriginalDestination() != null) {
                message.setOriginalDestination(message.getDestination());
            }
            if (message.getOriginalTransactionId() != null) {
                message.setOriginalTransactionId(message.getTransactionId());
            }
            ActiveMQTopic advisoryTopic = AdvisorySupport.getNoTopicConsumersAdvisoryTopic(this.destination);
            message.setDestination(advisoryTopic);
            message.setTransactionId(null);
            message.evictMarshlledForm();
            boolean originalFlowControl = context.isProducerFlowControl();
            try {
                context.setProducerFlowControl(false);
                context.getBroker().send(context, message);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }
}

