/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.Helper;

abstract class CommandLine {
    protected String commandName;
    protected CmdLineNotificationHandler notificationHandler;
    protected Process process;

    protected CommandLine(String string, CmdLineNotificationHandler cmdLineNotificationHandler) {
        this.commandName = string;
        this.notificationHandler = cmdLineNotificationHandler;
    }

    String version() throws CmdLineException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--version");
        return this.execString(arrayList, false);
    }

    protected Process execProcess(ArrayList arrayList) throws CmdLineException {
        int n = arrayList.size();
        String[] stringArray = new String[n + 1];
        stringArray[0] = this.commandName;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if ((object = arrayList.get(i)) != null) {
                object = object.toString();
            }
            if ("".equals(object)) {
                object = "\"\"";
            }
            if (bl) {
                stringBuffer.append("*******");
                bl = false;
            } else {
                stringBuffer.append(object);
            }
            if ("--password".equals(object)) {
                bl = true;
            }
            stringArray[i + 1] = (String)object;
        }
        this.notificationHandler.logCommandLine(stringBuffer.toString());
        try {
            this.process = Runtime.getRuntime().exec(stringArray, this.getEnvironmentVariables());
            return this.process;
        }
        catch (IOException iOException) {
            throw new CmdLineException(iOException);
        }
    }

    protected String[] getEnvironmentVariables() {
        String string = CmdLineClientAdapter.getEnvironmentVariable("PATH");
        String string2 = CmdLineClientAdapter.getEnvironmentVariable("SystemRoot");
        if (string != null) {
            if (string2 != null) {
                return new String[]{"LANG=C", "LC_ALL=C", "PATH=" + string, "SystemRoot=" + string2};
            }
            return new String[]{"LANG=C", "LC_ALL=C", "PATH=" + string};
        }
        if (string2 != null) {
            return new String[]{"LANG=C", "LC_ALL=C", "SystemRoot=" + string2};
        }
        return new String[]{"LANG=C", "LC_ALL=C"};
    }

    private void pumpProcessStreams(StreamPumper streamPumper, StreamPumper streamPumper2) {
        new Thread(streamPumper).start();
        new Thread(streamPumper2).start();
        try {
            streamPumper.waitFor();
            streamPumper2.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String execString(ArrayList arrayList, boolean bl) throws CmdLineException {
        Process process = this.execProcess(arrayList);
        CharacterStreamPumper characterStreamPumper = new CharacterStreamPumper(process.getInputStream(), bl);
        CharacterStreamPumper characterStreamPumper2 = new CharacterStreamPumper(process.getErrorStream(), false);
        this.pumpProcessStreams(characterStreamPumper, characterStreamPumper2);
        try {
            String string = ((Object)characterStreamPumper2).toString();
            if (string.length() > 0) {
                throw new CmdLineException(string);
            }
            String string2 = ((Object)characterStreamPumper).toString();
            this.notifyFromSvnOutput(string2);
            return string2;
        }
        catch (CmdLineException cmdLineException) {
            this.notificationHandler.logException(cmdLineException);
            throw cmdLineException;
        }
    }

    protected byte[] execBytes(ArrayList arrayList, boolean bl) throws CmdLineException {
        Process process = this.execProcess(arrayList);
        ByteStreamPumper byteStreamPumper = new ByteStreamPumper(process.getInputStream());
        CharacterStreamPumper characterStreamPumper = new CharacterStreamPumper(process.getErrorStream(), false);
        this.pumpProcessStreams(byteStreamPumper, characterStreamPumper);
        try {
            String string = ((Object)characterStreamPumper).toString();
            if (string.length() > 0) {
                throw new CmdLineException(string);
            }
            byte[] byArray = byteStreamPumper.getBytes();
            String string2 = "";
            if (bl) {
                try {
                    string2 = new String(byArray, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                string2 = new String(byArray);
            }
            this.notifyFromSvnOutput(string2);
            return byArray;
        }
        catch (CmdLineException cmdLineException) {
            this.notificationHandler.logException(cmdLineException);
            throw cmdLineException;
        }
    }

    protected void execVoid(ArrayList arrayList) throws CmdLineException {
        this.execString(arrayList, false);
    }

    protected void notifyFromSvnOutput(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, Helper.NEWLINE);
        int n = stringTokenizer.countTokens();
        for (int i = 1; i < n; ++i) {
            this.notificationHandler.logMessage(stringTokenizer.nextToken());
        }
        if (n > 0) {
            this.notificationHandler.logCompleted(stringTokenizer.nextToken());
        }
    }

    protected void stopProcess() {
        this.process.destroy();
    }

    private static class ByteStreamPumper
    extends StreamPumper {
        private InputStream bis;
        private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private static final int BUFFER_LENGTH = 1024;
        private byte[] inputBuffer = new byte[1024];

        public ByteStreamPumper(InputStream inputStream) {
            this.bis = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void pumpStream() {
            block9: {
                int n;
                while ((n = this.bis.read(this.inputBuffer)) != -1) {
                    this.bytes.write(this.inputBuffer, 0, n);
                }
                Object var3_3 = null;
                try {
                    this.bytes.flush();
                    this.bytes.close();
                    this.bis.close();
                }
                catch (IOException iOException) {}
                break block9;
                {
                    catch (IOException iOException) {
                        System.err.println("Problem occured during fetching the command output: " + iOException.getMessage());
                        Object var3_4 = null;
                        try {
                            this.bytes.flush();
                            this.bytes.close();
                            this.bis.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        this.bytes.flush();
                        this.bytes.close();
                        this.bis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public synchronized byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    private static class CharacterStreamPumper
    extends StreamPumper {
        private BufferedReader reader;
        private StringBuffer sb = new StringBuffer();
        private boolean coalesceLines = false;

        public CharacterStreamPumper(InputStream inputStream, boolean bl) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.coalesceLines = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pumpStream() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    if (this.coalesceLines) {
                        this.sb.append(string);
                        continue;
                    }
                    this.sb.append(string).append(Helper.NEWLINE);
                }
            }
            catch (IOException iOException) {
                System.err.println("Problem occured during fetching the command output: " + iOException.getMessage());
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized String toString() {
            return this.sb.toString();
        }
    }

    private static abstract class StreamPumper
    implements Runnable {
        private boolean finished;

        private StreamPumper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StreamPumper streamPumper;
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.finished = false;
            }
            try {
                this.pumpStream();
                Object var4_3 = null;
                streamPumper = this;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                StreamPumper streamPumper3 = this;
                synchronized (streamPumper3) {
                    this.finished = true;
                    this.notify();
                }
                throw throwable;
            }
            synchronized (streamPumper) {
                this.finished = true;
                this.notify();
            }
        }

        protected abstract void pumpStream();

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }
    }
}

