/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FileSizeFormat {
    private static NumberFormat intFormat = DecimalFormat.getIntegerInstance();
    private NumberFormat decimalFormat = (NumberFormat)DecimalFormat.getNumberInstance().clone();
    private static FileSizeFormat instance;
    private boolean isAlwaysIncludeBytes = false;
    private boolean isShort = false;
    private int limit = 999;
    private int scale = 1024;

    public FileSizeFormat() {
        this.decimalFormat.setMaximumFractionDigits(1);
    }

    public void setMaximumFractionDigits(int newValue) {
        this.decimalFormat.setMaximumFractionDigits(newValue);
    }

    public void setAlwaysIncludeBytes(boolean newValue) {
        this.isAlwaysIncludeBytes = newValue;
    }

    public void setShortFormat(boolean newValue) {
        this.isShort = newValue;
    }

    public void setMebibyte(boolean isMebibyte) {
        this.scale = isMebibyte ? 1024 : 1000;
    }

    public boolean isMebibyte() {
        return this.scale == 1024;
    }

    public String format(long w) {
        return this.isShort ? this.formatShort(w) : this.formatLong(w);
    }

    private String formatLong(long w) {
        double scaledW = w;
        String scaledUnit = "bytes";
        if (scaledW > (double)this.limit) {
            scaledW /= (double)this.scale;
            scaledUnit = "KB";
            if (scaledW > (double)this.limit) {
                scaledW /= (double)this.scale;
                scaledUnit = "MB";
                if (scaledW > (double)this.limit) {
                    scaledW /= (double)this.scale;
                    scaledUnit = "GB";
                    if (scaledW > (double)this.limit) {
                        scaledW /= (double)this.scale;
                        scaledUnit = "TB";
                    }
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.decimalFormat.format(scaledW));
        buf.append(' ');
        buf.append(scaledUnit);
        if (this.isAlwaysIncludeBytes && scaledUnit != "bytes") {
            buf.append(" (");
            buf.append(this.decimalFormat.format(w));
            buf.append(" bytes)");
        }
        return buf.toString();
    }

    private String formatShort(long w) {
        double scaledW = w;
        String scaledUnit = "bytes";
        if (scaledW > (double)this.limit) {
            scaledW /= (double)this.scale;
            scaledUnit = "K";
            if (scaledW > (double)this.limit) {
                scaledW /= (double)this.scale;
                scaledUnit = "M";
                if (scaledW > (double)this.limit) {
                    scaledW /= (double)this.scale;
                    scaledUnit = "G";
                    if (scaledW > (double)this.limit) {
                        scaledW /= (double)this.scale;
                        scaledUnit = "T";
                    }
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        if (scaledUnit == "bytes") {
            buf.append(this.decimalFormat.format(scaledW / (double)this.scale));
            buf.append("K");
        } else {
            if (scaledW < 10.0) {
                buf.append(this.decimalFormat.format(scaledW));
            } else {
                buf.append(intFormat.format(scaledW));
            }
            buf.append(scaledUnit);
        }
        return buf.toString();
    }

    public static FileSizeFormat getInstance() {
        if (instance == null) {
            instance = new FileSizeFormat();
        }
        return instance;
    }
}

