/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

public class Complex
implements Cloneable {
    private double x;
    private double y;

    public Complex(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double real() {
        return this.x;
    }

    public double img() {
        return this.y;
    }

    public Complex add(Complex that) {
        return new Complex(this.x + that.x, this.y + that.y);
    }

    public static Complex add(Complex a, Complex b) {
        return a.add(b);
    }

    public Complex sub(Complex that) {
        return new Complex(this.x - that.x, this.y - that.y);
    }

    public static Complex sub(Complex a, Complex b) {
        return a.sub(b);
    }

    public Complex mul(Complex that) {
        return new Complex(this.x * that.x - this.y * that.y, this.x * that.y + this.y * that.x);
    }

    public static Complex mul(Complex a, Complex b) {
        return a.mul(b);
    }

    public Complex div(Complex that) {
        return new Complex((this.x * that.x + this.y * that.y) / (that.x * that.x + that.y * that.y), (this.y * that.x - this.x * that.y) / (that.x * that.x + that.y * that.y));
    }

    public static Complex div(Complex a, Complex b) {
        return a.div(b);
    }

    public double arg() {
        return Math.atan2(this.y, this.x);
    }

    public double mod() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Complex sqrt() {
        double r = Math.sqrt(this.mod());
        double theta = this.arg() / 2.0;
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public boolean equals(Object o) {
        if (o instanceof Complex) {
            Complex that = (Complex)o;
            return that.x == this.x && that.y == this.y;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        return (int)(bits ^= Double.doubleToLongBits(this.y) * 31L) ^ (int)(bits >> 32);
    }

    public Complex clone() {
        try {
            return (Complex)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Cloneable not implemented");
        }
    }

    public String toString() {
        if (this.y >= 0.0) {
            return "(" + this.x + "+" + this.y + "i)";
        }
        return "(" + this.x + "" + this.y + "i)";
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    public static void main(String[] args) {
        System.out.println(new Complex(3.0, 2.0).add(new Complex(5.0, 5.0)));
        System.out.println(new Complex(5.0, 5.0).sub(new Complex(3.0, 2.0)));
        System.out.println(new Complex(2.0, 5.0).mul(new Complex(3.0, 7.0)));
        System.out.println(new Complex(2.0, 5.0).div(new Complex(3.0, 7.0)));
        System.out.println(new Complex(4.0, 0.0).sqrt());
        System.out.println(new Complex(2.0, 0.0).add(new Complex(2.0, 0.0)).sqrt());
        System.out.println(new Complex(1.0, 0.0).sqrt());
        System.out.println(new Complex(3.0, 4.0).sqrt());
        System.out.println(new Complex(-9.0, 0.0).sqrt());
    }
}

