/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunray;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.sunray.SunrayDraw;
import ch.randelshofer.tree.sunray.SunrayNode;
import ch.randelshofer.tree.sunray.SunrayTree;
import ch.randelshofer.tree.sunray.SunrayViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class SunrayView
extends JPanel
implements SunrayViewer,
TreeView {
    private SunrayDraw draw;
    private SunrayDraw subDraw;
    private BufferedImage img;
    private boolean isInvalid;
    private Thread worker;
    private boolean drawHandles;
    private boolean isAdjusting;
    private boolean needsSimplify;
    private boolean isToolTipVisible = false;
    private SunrayNode selectedNode;
    private SunrayNode hoverNode;
    private NodeInfo info;

    public SunrayView() {
        this.init();
    }

    public SunrayView(SunrayTree model) {
        this.draw = new SunrayDraw(model.getRoot(), model.getInfo());
        this.info = model.getInfo();
        this.init();
    }

    private void init() {
        this.initComponents();
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setMaxDepth(int newValue) {
    }

    public int getMaxDepth() {
        return Integer.MAX_VALUE;
    }

    private void setRotation(double rotation) {
        this.draw.setRotation(rotation);
        if (this.subDraw != null) {
            this.subDraw.setRotation(rotation);
        }
    }

    private void setCenter(double cx, double cy) {
        this.draw.setCX(cx);
        this.draw.setCY(cy);
        if (this.subDraw != null) {
            this.subDraw.setCX(cx);
            this.subDraw.setCY(cy);
        }
    }

    private void setOuterRadius(double r) {
        if (this.subDraw != null) {
            this.draw.setOuterRadius(r / 2.0 - r / 2.0 / (double)this.draw.getTotalDepth());
            this.subDraw.setOuterRadius(r);
            if (this.subDraw.getRoot().children().size() == 0) {
                this.subDraw.setInnerRadius(r / 2.0);
            } else {
                this.subDraw.setInnerRadius(r / 2.0 - r / 2.0 / (double)this.draw.getTotalDepth());
            }
        } else {
            this.draw.setOuterRadius(r);
        }
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            if (this.img == null) {
                this.setCenter((double)w / 2.0, (double)h / 2.0);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            } else {
                this.setCenter(this.draw.getCX() / (double)this.img.getWidth() * (double)w, this.draw.getCY() / (double)this.img.getHeight() * (double)h);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            }
            this.img = null;
            this.img = new BufferedImage(w, h, 1);
            this.isInvalid = true;
        }
        if (this.isInvalid) {
            this.isInvalid = false;
            g = this.img.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setBackground(Color.WHITE);
            g.setFont(this.getFont());
            g.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
            if (this.isAdjusting && this.needsSimplify) {
                this.draw.drawContours(g, this.draw.getRoot(), Color.gray);
                if (this.subDraw != null) {
                    this.subDraw.drawContours(g, this.subDraw.getRoot(), Color.gray);
                }
            } else {
                long end;
                long start = System.currentTimeMillis();
                this.draw.drawTree(g);
                if (this.subDraw != null) {
                    if (this.subDraw.getRoot().children().size() == 0) {
                        this.subDraw.drawTree(g);
                    } else {
                        this.subDraw.drawDescendants(g, this.subDraw.getRoot());
                    }
                }
                this.needsSimplify = (end = System.currentTimeMillis()) - start > 500L;
            }
            g.dispose();
        }
        if (this.worker == null) {
            gr.drawImage(this.img, 0, 0, this);
        }
        if (this.selectedNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selectedNode.children().size() == 0) {
                this.draw.drawSubtreeBounds(g, this.selectedNode, Color.red);
            } else {
                this.draw.drawDescendantSubtreeBounds(g, this.selectedNode, Color.red);
            }
        }
        if (this.hoverNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.draw.drawNodeBounds(g, this.hoverNode, Color.black);
            if (this.subDraw != null && this.subDraw.getRoot().isDescendant(this.hoverNode) && (this.hoverNode != this.subDraw.getRoot() || this.subDraw.getRoot().children().size() == 0)) {
                this.subDraw.drawNodeBounds(g, this.hoverNode, Color.BLACK);
            }
        }
        if (this.drawHandles) {
            g = (Graphics2D)gr;
            double cx = this.draw.getCX();
            double cy = this.draw.getCY();
            g.setColor(Color.BLACK);
            AffineTransform t = new AffineTransform();
            t.translate(cx, cy);
            t.rotate(this.draw.getRotation() * Math.PI / -180.0);
            AffineTransform oldT = (AffineTransform)g.getTransform().clone();
            g.setTransform(t);
            g.draw(new Line2D.Double(-5.0, 0.0, 5.0, 0.0));
            g.draw(new Line2D.Double(0.0, -5.0, 0.0, 5.0));
            g.setTransform(oldT);
        }
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        SunrayNode node = this.draw.getNodeAt(x, y = event.getY());
        if (node == null && this.subDraw != null && (node = this.subDraw.getNodeAt(x, y)) == this.subDraw.getRoot() && this.subDraw.getRoot().children().size() != 0) {
            node = null;
        }
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void setSelectedNode(SunrayNode newValue) {
        this.selectedNode = newValue;
        if (this.selectedNode == null) {
            if (this.subDraw != null) {
                this.draw.setOuterRadius(this.subDraw.getOuterRadius());
                this.subDraw = null;
            }
        } else {
            double outerRadius = this.subDraw == null ? this.draw.getOuterRadius() : this.subDraw.getOuterRadius();
            this.subDraw = this.selectedNode.children().size() == 0 ? new SunrayDraw(this.selectedNode, this.draw.getInfo()) : new SunrayDraw(this.selectedNode, this.draw.getInfo());
            this.setRotation(this.draw.getRotation());
            this.setOuterRadius(outerRadius);
            this.setCenter(this.draw.getCX(), this.draw.getCY());
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private double alphaStart;
        private boolean isMove;
        private Point moveStart;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            SunrayNode node = SunrayView.this.draw.getNodeAt(evt.getX(), evt.getY());
            if (node == null && SunrayView.this.subDraw != null && (node = SunrayView.this.subDraw.getNodeAt(evt.getX(), evt.getY())) == SunrayView.this.subDraw.getRoot() && SunrayView.this.subDraw.getRoot().children().size() != 0) {
                node = null;
            }
            if (node == SunrayView.this.draw.getRoot()) {
                SunrayView.this.setSelectedNode(null);
                if (evt.getClickCount() == 2) {
                    SunrayView.this.setCenter(SunrayView.this.getWidth() / 2, SunrayView.this.getHeight() / 2);
                    SunrayView.this.setSelectedNode(null);
                }
            } else {
                SunrayView.this.setSelectedNode(node);
            }
            SunrayView.this.isInvalid = true;
            SunrayView.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            this.isMove = SunrayView.this.draw.getNodeAt(e.getX(), e.getY()) == SunrayView.this.draw.getRoot();
            this.moveStart = e.getPoint();
            this.alphaStart = SunrayView.this.draw.getTheta(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            if (SunrayView.this.drawHandles || SunrayView.this.isAdjusting) {
                SunrayView.this.drawHandles = false;
                if (SunrayView.this.isAdjusting) {
                    SunrayView.this.isAdjusting = false;
                    SunrayView.this.isInvalid = true;
                }
                SunrayView.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (SunrayView.this.drawHandles) {
                SunrayView.this.drawHandles = false;
                SunrayView.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            SunrayView.this.isAdjusting = true;
            if (this.isMove) {
                Point moveNow = e.getPoint();
                int cx = (int)SunrayView.this.draw.getCX();
                int cy = (int)SunrayView.this.draw.getCY();
                SunrayView.this.setCenter(cx + moveNow.x - this.moveStart.x, cy + moveNow.y - this.moveStart.y);
                this.moveStart = moveNow;
                SunrayView.this.isInvalid = true;
                SunrayView.this.repaint();
            } else {
                double alphaNow = SunrayView.this.draw.getTheta(e.getX(), e.getY());
                SunrayView.this.setRotation(SunrayView.this.draw.getRotation() - alphaNow + this.alphaStart);
                SunrayView.this.isInvalid = true;
                SunrayView.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            SunrayView.this.hoverNode = SunrayView.this.draw.getNodeAt(e.getX(), e.getY());
            if (SunrayView.this.hoverNode == null && SunrayView.this.subDraw != null) {
                SunrayView.this.hoverNode = SunrayView.this.subDraw.getNodeAt(e.getX(), e.getY());
                if (SunrayView.this.hoverNode == SunrayView.this.subDraw.getRoot() && SunrayView.this.subDraw.getRoot().children().size() != 0) {
                    SunrayView.this.hoverNode = null;
                }
            }
            SunrayView.this.repaint();
        }
    }
}

