/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunray;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunrayNode {
    private TreePath2<TreeNode> dataNodePath;
    protected long left;
    protected long right;
    private int internalDepth;
    protected int maxScatter;
    protected int totalScatter;
    private int maxDepth = -1;
    private int maxRayDepth = -1;
    private SunrayNode parent;

    public SunrayNode(SunrayNode parent, TreeNode data, int depth) {
        this.parent = parent;
        this.dataNodePath = parent == null ? new TreePath2(data) : parent.getDataNodePath().pathByAddingChild(data);
    }

    public TreePath2<TreeNode> getDataNodePath() {
        return this.dataNodePath;
    }

    public SunrayNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public int getMaxScatter() {
        return this.maxScatter;
    }

    public int getMaxDepth() {
        if (this.maxDepth == -1) {
            this.maxDepth = this.getMaxDepth(this, 1);
        }
        return this.maxDepth;
    }

    private int getMaxDepth(SunrayNode node, int depth) {
        int max = depth;
        for (SunrayNode child : node.children()) {
            max = Math.max(max, this.getMaxDepth(child, depth + 1));
        }
        return max;
    }

    public int getMaxRayDepth() {
        if (this.maxRayDepth == -1) {
            this.maxRayDepth = this.getMaxRayDepth(this, 1);
        }
        return this.maxRayDepth;
    }

    private int getMaxRayDepth(SunrayNode node, int depth) {
        int max = depth;
        if (this.children().size() > 0) {
            max += this.totalScatter / this.maxScatter;
        }
        for (SunrayNode child : node.children()) {
            max = Math.max(max, this.getMaxDepth(child, depth + 1));
        }
        return max;
    }

    public void renumber() {
        this.renumber(4);
    }

    public void renumber(int maxScatter) {
        this.renumber(0, 0, 0, maxScatter, this.getMaxDepth() - 1);
    }

    protected int renumber(int depth, int number, int scatter, int maxScatter, int maxDepth) {
        this.internalDepth = scatter;
        this.maxScatter = maxScatter;
        this.totalScatter = maxDepth * maxScatter;
        if (scatter == this.totalScatter - 1) {
            this.left = number++;
            this.right = number;
        } else {
            this.left = number;
            this.right = number + 1;
        }
        return number;
    }

    public List<SunrayNode> children() {
        return Collections.EMPTY_LIST;
    }

    public void dump() {
        System.out.println(this.getDepth() + "," + this.left + "," + this.right + " " + this.toString());
        for (SunrayNode child : this.children()) {
            child.dump();
        }
    }

    public boolean isLeaf() {
        return !this.dataNodePath.getLastPathComponent().getAllowsChildren();
    }

    public long getLeft() {
        return this.left;
    }

    public long getRight() {
        return this.right;
    }

    public long getExtent() {
        return this.right - this.left;
    }

    public int getDepth() {
        return this.dataNodePath.getPathCount();
    }

    public int getScatter() {
        return this.internalDepth;
    }

    public void setScatter(int newValue) {
        this.internalDepth = newValue;
    }

    public boolean isDescendant(SunrayNode node) {
        return node.getLeft() >= this.getLeft() && node.getRight() <= this.getRight() && node.getDepth() >= this.getDepth();
    }

    public SunrayNode findNode(int depth, long number, int scatter) {
        if (this.getLeft() <= number && this.getRight() > number) {
            if (this.isLeaf() ? this.internalDepth == scatter + this.maxScatter * depth : depth == 0) {
                return this;
            }
            for (SunrayNode child : this.children()) {
                SunrayNode found = child.findNode(depth - 1, number, scatter);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

