/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunray;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.sunray.SunrayNode;
import ch.randelshofer.tree.sunray.SunrayTree;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class SunrayDraw {
    private double cx = 100.0;
    private double cy = 100.0;
    private double innerRadius = 0.0;
    private double outerRadius = 96.0;
    private SunrayNode root;
    private int totalDepth;
    private double numberToAngleFactor;
    private double rotation;
    private NodeInfo info;
    private int maxScatter = 4;

    public SunrayDraw(SunrayTree model) {
        this(model.getRoot(), model.getInfo());
    }

    public SunrayDraw(SunrayNode root, NodeInfo info) {
        this.root = root;
        this.info = info;
        this.totalDepth = root.getMaxRayDepth();
        this.numberToAngleFactor = Math.PI * 2 / (double)root.getExtent();
        this.rotation = 0.0;
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public SunrayNode getRoot() {
        return this.root;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double newValue) {
        this.rotation = (Math.PI * 2 + newValue) % (Math.PI * 2);
    }

    public int getTotalDepth() {
        return this.totalDepth;
    }

    public double getCX() {
        return this.cx;
    }

    public void setCX(double newValue) {
        this.cx = newValue;
    }

    public double getCY() {
        return this.cy;
    }

    public void setCY(double newValue) {
        this.cy = newValue;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double newValue) {
        this.innerRadius = newValue;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double newValue) {
        this.outerRadius = newValue;
    }

    private double getRadius(int depth) {
        return this.innerRadius + (this.outerRadius - this.innerRadius) * (double)depth / (double)this.totalDepth;
    }

    private int getMaxScatter() {
        return this.maxScatter;
    }

    public double getTheta(double x, double y) {
        return ((Math.atan2(this.cx - x, y - this.cy) + this.rotation) / Math.PI * 180.0 + 360.0) % 360.0 / 180.0 * Math.PI;
    }

    public SunrayNode getNodeAt(int x, int y) {
        double r = Math.sqrt((this.cx - (double)x) * (this.cx - (double)x) + (this.cy - (double)y) * (this.cy - (double)y));
        if (r < this.innerRadius || r > this.outerRadius) {
            return null;
        }
        double theta = this.getTheta(x, y);
        int depth = (int)((r - this.innerRadius) / (this.outerRadius - this.innerRadius) * (double)this.totalDepth);
        int scatter = (int)((r - this.getRadius(depth)) * (double)this.maxScatter / (this.getRadius(depth + 1) - this.getRadius(depth)));
        long number = (long)(theta / this.numberToAngleFactor) + this.root.getLeft();
        return this.root.findNode(depth, number, scatter);
    }

    public String getToolTipText(int x, int y) {
        SunrayNode node = this.getNodeAt(x, y);
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void drawNodeBounds(Graphics2D g, SunrayNode node, Color color) {
        double ro;
        double ri;
        if (node.isLeaf()) {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double shift = (ro - ri) / (double)node.getMaxScatter();
            ro = (ri += shift * (double)node.getScatter()) + shift;
            ro -= 1.0;
        } else {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1) - 1.0;
        }
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.getRotation();
        double arc = (double)(node.getRight() - node.getLeft()) * this.numberToAngleFactor;
        GeneralPath path = SunrayDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
        g.setColor(color);
        g.draw(path);
    }

    public void drawSubtreeBounds(Graphics2D g, SunrayNode node, Color color) {
        double ro;
        double ri;
        if (node.isLeaf()) {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double shift = (ro - ri) / (double)node.getMaxScatter();
            ro = (ri += shift * (double)node.getScatter()) + shift;
        } else {
            ro = this.getRadius(this.totalDepth);
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
        }
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.getRotation();
        double arc = (double)(node.getRight() - node.getLeft()) * this.numberToAngleFactor;
        GeneralPath path = SunrayDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
        g.setColor(color);
        g.draw(path);
    }

    public void drawDescendantSubtreeBounds(Graphics2D g, SunrayNode selectedNode, Color color) {
        double ro = this.getRadius(this.totalDepth);
        double ri = this.getRadius(selectedNode.getDepth() - this.root.getDepth() + 1);
        double startAngle = (double)selectedNode.getLeft() * this.numberToAngleFactor - this.getRotation();
        double arc = (double)(selectedNode.getRight() - selectedNode.getLeft()) * this.numberToAngleFactor;
        GeneralPath path = SunrayDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
        g.setColor(color);
        g.draw(path);
    }

    public static GeneralPath createArc(double x, double y, double startAngle, double arc, double outerRadius, double innerRadius) {
        GeneralPath mc = new GeneralPath();
        double by = 0.0;
        double bx = 0.0;
        if (Math.abs(arc) > 360.0) {
            arc = 360.0;
        }
        double segs = Math.ceil(Math.abs(arc) / 45.0);
        double segAngle_a = arc / segs;
        double segAngle_b = -arc / segs;
        double theta_a = -(segAngle_a / 180.0) * Math.PI;
        double theta_b = -(segAngle_b / 180.0) * Math.PI;
        double angle = -(startAngle / 180.0) * Math.PI;
        if (segs > 0.0) {
            double cy;
            double cx;
            double angleMid;
            double ax = x + Math.sin(-startAngle / 180.0 * Math.PI) * outerRadius;
            double ay = y + Math.cos(startAngle / 180.0 * Math.PI) * outerRadius;
            mc.moveTo((float)ax, (float)ay);
            int i = 0;
            while ((double)i < segs) {
                angleMid = (angle += theta_a) - theta_a / 2.0;
                bx = x + Math.sin(angle) * outerRadius;
                by = y + Math.cos(angle) * outerRadius;
                cx = x + Math.sin(angleMid) * (outerRadius / Math.cos(theta_a / 2.0));
                cy = y + Math.cos(angleMid) * (outerRadius / Math.cos(theta_a / 2.0));
                mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                ++i;
            }
            angle = -((startAngle += arc) / 180.0) * Math.PI;
            double dx = x + Math.sin(-startAngle / 180.0 * Math.PI) * innerRadius;
            double dy = y + Math.cos(startAngle / 180.0 * Math.PI) * innerRadius;
            if (innerRadius > 0.0) {
                if (arc < 360.0) {
                    mc.lineTo((float)dx, (float)dy);
                } else {
                    mc.moveTo((float)dx, (float)dy);
                }
                i = 0;
                while ((double)i < segs) {
                    angleMid = (angle += theta_b) - theta_b / 2.0;
                    bx = x + Math.sin(angle) * innerRadius;
                    by = y + Math.cos(angle) * innerRadius;
                    cx = x + Math.sin(angleMid) * (innerRadius / Math.cos(theta_b / 2.0));
                    cy = y + Math.cos(angleMid) * (innerRadius / Math.cos(theta_b / 2.0));
                    mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                    ++i;
                }
            }
            if (arc < 360.0) {
                mc.lineTo((float)ax, (float)ay);
            }
        }
        return mc;
    }

    public static void addSeg(GeneralPath mc, double x, double y, double startAngle, double arc, double radius) {
        double by = 0.0;
        double bx = 0.0;
        if (Math.abs(arc) > 360.0) {
            arc = 360.0;
        }
        double segs = Math.ceil(Math.abs(arc) / 45.0);
        double segAngle_a = arc / segs;
        double segAngle_b = -arc / segs;
        double theta_a = -(segAngle_a / 180.0) * Math.PI;
        double theta_b = -(segAngle_b / 180.0) * Math.PI;
        double angle = -(startAngle / 180.0) * Math.PI;
        if (segs > 0.0) {
            double ax = x + Math.sin(-startAngle / 180.0 * Math.PI) * radius;
            double ay = y + Math.cos(startAngle / 180.0 * Math.PI) * radius;
            mc.moveTo((float)ax, (float)ay);
            int i = 0;
            while ((double)i < segs) {
                double angleMid = (angle += theta_a) - theta_a / 2.0;
                bx = x + Math.sin(angle) * radius;
                by = y + Math.cos(angle) * radius;
                double cx = x + Math.sin(angleMid) * (radius / Math.cos(theta_a / 2.0));
                double cy = y + Math.cos(angleMid) * (radius / Math.cos(theta_a / 2.0));
                mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                ++i;
            }
        }
    }

    public void drawTree(Graphics2D g) {
        this.drawTree(g, this.root);
    }

    public void drawTree(Graphics2D g, SunrayNode node) {
        this.drawNode(g, node);
        this.drawLabel(g, node);
        for (SunrayNode child : node.children()) {
            this.drawTree(g, child);
        }
    }

    public void drawContours(Graphics2D g, SunrayNode node, Color color) {
        GeneralPath path = new GeneralPath();
        this.addArc(path, node);
        g.setColor(color);
        g.draw(path);
    }

    private void addArc(GeneralPath path, SunrayNode node) {
        if (!node.isLeaf()) {
            double ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
            double arc = (double)node.getExtent() * this.numberToAngleFactor;
            SunrayDraw.addSeg(path, this.cx, this.cy, startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro);
        }
        for (SunrayNode child : node.children()) {
            this.addArc(path, child);
        }
    }

    public void drawDescendants(Graphics2D g, SunrayNode node) {
        for (SunrayNode child : node.children()) {
            this.drawTree(g, child);
        }
    }

    public void drawLabel(Graphics2D g, SunrayNode node) {
        double ro;
        double ri;
        if (node.isLeaf()) {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double shift = (ro - ri) / (double)node.getMaxScatter();
            ro = (ri += shift * (double)node.getScatter()) + shift;
        } else {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
        }
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double endAngle = (double)(node.getRight() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double arc = (double)node.getExtent() * this.numberToAngleFactor;
        double sx = this.cx + Math.cos(startAngle) * ri;
        double sy = this.cy + Math.sin(-startAngle) * ri;
        double ex = this.cx + Math.cos(endAngle) * ri;
        double ey = this.cy + Math.sin(-endAngle) * ri;
        double seg = Math.sqrt((sx - ex) * (sx - ex) + (sy - ey) * (sy - ey));
        g.setColor(Color.BLACK);
        FontMetrics fm = g.getFontMetrics();
        int fh = fm.getHeight();
        if ((double)fh < seg || arc > Math.PI) {
            double space = ro - ri - 8.0;
            String name = this.info.getName(node.getDataNodePath());
            char[] nameC = name == null ? new char[]{} : name.toCharArray();
            int nameLength = nameC.length;
            int nameWidth = fm.charsWidth(nameC, 0, nameLength);
            while ((double)nameWidth >= space && nameLength > 1) {
                nameC[--nameLength - 1] = 183;
                nameWidth = fm.charsWidth(nameC, 0, nameLength);
            }
            if (nameLength > 1 || nameLength == nameC.length) {
                AffineTransform t = new AffineTransform();
                t.translate(this.cx, this.cy);
                t.rotate((startAngle + endAngle + Math.PI) / 2.0);
                AffineTransform oldT = (AffineTransform)g.getTransform().clone();
                g.setTransform(t);
                g.drawString(new String(nameC, 0, nameLength), (int)ri + 4, fm.getAscent() - fh / 2);
                g.setTransform(oldT);
            }
        }
    }

    public void drawNode(Graphics2D g, SunrayNode node) {
        double less;
        double ro;
        double ri;
        if (node.isLeaf()) {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double shift = (ro - ri) / (double)node.getMaxScatter();
            ro = (ri += shift * (double)node.getScatter()) + shift;
            less = node.getExtent() == this.root.getExtent() ? 0.0 : 0.3141592653589793 / ri;
        } else {
            ri = this.getRadius(node.getDepth() - this.root.getDepth());
            if (ri > 0.0) {
                ri += 1.0;
            }
            ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1) - 1.0;
            less = node.getExtent() == this.root.getExtent() ? 0.0 : 0.9424777960769379 / ri;
        }
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double arc = (double)node.getExtent() * this.numberToAngleFactor;
        if (arc < Math.PI * 2 - less && arc > less * 4.0) {
            startAngle += less;
            arc -= less * 2.0;
        }
        GeneralPath path = SunrayDraw.createArc(this.cx, this.cy, startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro - 1.0, ri);
        g.setColor(this.info.getColor(node.getDataNodePath()));
        if (node.isLeaf()) {
            g.fill(path);
        } else {
            g.draw(path);
        }
    }
}

