/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunray;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.sunray.SunrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunrayCompositeNode
extends SunrayNode {
    private ArrayList<SunrayNode> children = new ArrayList();

    public SunrayCompositeNode(SunrayNode parent, TreeNode node, int depth) {
        super(parent, node, depth);
        for (TreeNode c : node.children()) {
            if (!c.getAllowsChildren()) continue;
            this.children.add(new SunrayCompositeNode(this, c, depth + 1));
        }
        for (TreeNode c : node.children()) {
            if (c.getAllowsChildren()) continue;
            this.children.add(new SunrayNode(this, c, depth + 1));
        }
    }

    @Override
    public List<SunrayNode> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    protected int renumber(int depth, int number, int scatter, int maxScatter, int maxDepth) {
        this.maxScatter = maxScatter;
        this.totalScatter = maxDepth * maxScatter;
        if (this.children().size() == 0) {
            this.left = number++;
            this.right = number;
        } else {
            scatter = 0;
            this.left = number;
            for (SunrayNode child : this.children()) {
                if (!child.isLeaf() && scatter > 0) {
                    ++number;
                }
                if (child.isLeaf()) {
                    number = child.renumber(depth + 1, number, scatter, maxScatter, maxDepth);
                    scatter = (scatter + 1) % this.totalScatter;
                    continue;
                }
                number = child.renumber(depth + 1, number, scatter, maxScatter, maxDepth - 1);
                scatter = 0;
            }
            if (scatter != 0) {
                ++number;
            }
            this.right = number;
        }
        return number;
    }
}

