/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunburst;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressTracker;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.sunburst.SunburstDraw;
import ch.randelshofer.tree.sunburst.SunburstNode;
import ch.randelshofer.tree.sunburst.SunburstTree;
import ch.randelshofer.tree.sunburst.SunburstViewer;
import ch.randelshofer.util.SequentialDispatcher;
import ch.randelshofer.util.Worker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class SunburstView
extends JPanel
implements SunburstViewer,
TreeView {
    private SunburstDraw draw;
    private SunburstDraw subDraw;
    private BufferedImage img;
    private boolean isInvalid;
    private Thread worker;
    private ProgressObserver workerProgress;
    private boolean drawHandles;
    private boolean isAdjusting;
    private boolean needsSimplify;
    private boolean needsProgressive = true;
    private boolean isToolTipVisible = false;
    private SunburstNode selectedNode;
    private SunburstNode hoverNode;
    private NodeInfo info;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();

    public SunburstView() {
        this.init();
    }

    public SunburstView(SunburstTree model) {
        this.draw = new SunburstDraw(model);
        this.info = model.getInfo();
        this.init();
    }

    private void init() {
        this.initComponents();
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setMaxDepth(int newValue) {
    }

    public int getMaxDepth() {
        return Integer.MAX_VALUE;
    }

    private void setRotation(double rotation) {
        this.draw.setRotation(rotation);
        if (this.subDraw != null) {
            this.subDraw.setRotation(rotation);
        }
    }

    private void setCenter(double cx, double cy) {
        this.draw.setCX(cx);
        this.draw.setCY(cy);
        if (this.subDraw != null) {
            this.subDraw.setCX(cx);
            this.subDraw.setCY(cy);
        }
    }

    private void setOuterRadius(double r) {
        if (this.subDraw != null) {
            this.draw.setOuterRadius(r / 2.0 - r / 2.0 / (double)this.draw.getTotalDepth());
            this.subDraw.setOuterRadius(r);
            if (this.subDraw.getRoot().children().size() == 0) {
                this.subDraw.setInnerRadius(r / 2.0);
            } else {
                this.subDraw.setInnerRadius(r / 2.0 - r / 2.0 / (double)this.subDraw.getTotalDepth());
            }
        } else {
            this.draw.setOuterRadius(r);
        }
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            if (this.img == null) {
                this.setCenter((double)w / 2.0, (double)h / 2.0);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            } else {
                this.setCenter(this.draw.getCX() / (double)this.img.getWidth() * (double)w, this.draw.getCY() / (double)this.img.getHeight() * (double)h);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            }
            this.img = null;
            this.img = new BufferedImage(w, h, 1);
            this.isInvalid = true;
        }
        if (this.isInvalid && (this.workerProgress == null || this.workerProgress.isClosed())) {
            this.isInvalid = false;
            final BufferedImage workingImage = this.img;
            this.workerProgress = new ProgressTracker("Sunburst Tree", "Drawing...");
            this.workerProgress.setIndeterminate(true);
            final ProgressObserver p = this.workerProgress;
            final Timer timer = new Timer(33, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SunburstView.this.repaint();
                }
            });
            timer.isRepeats();
            timer.start();
            Worker worker = new Worker(){

                public Object construct() {
                    Graphics2D g = workingImage.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setBackground(Color.WHITE);
                    g.setFont(SunburstView.this.getFont());
                    g.clearRect(0, 0, SunburstView.this.img.getWidth(), SunburstView.this.img.getHeight());
                    if (SunburstView.this.isAdjusting && SunburstView.this.needsSimplify) {
                        SunburstView.this.draw.drawContours(g, SunburstView.this.draw.getRoot(), Color.gray);
                        if (SunburstView.this.subDraw != null) {
                            SunburstView.this.subDraw.drawContours(g, SunburstView.this.subDraw.getRoot(), Color.gray);
                        }
                    } else {
                        long end;
                        long start = System.currentTimeMillis();
                        SunburstView.this.draw.drawTree(g, p);
                        if (SunburstView.this.subDraw != null) {
                            if (SunburstView.this.subDraw.getRoot().children().size() == 0) {
                                SunburstView.this.subDraw.drawTree(g, p);
                            } else {
                                SunburstView.this.subDraw.drawDescendants(g, SunburstView.this.subDraw.getRoot(), p);
                            }
                        }
                        SunburstView.this.needsSimplify = (end = System.currentTimeMillis()) - start > 99L;
                        SunburstView.this.needsProgressive = end - start > 33L;
                        SunburstView.this.isInvalid = false;
                    }
                    g.dispose();
                    return null;
                }

                public void done(Object value) {
                    SunburstView.this.workerProgress.close();
                    SunburstView.this.workerProgress = null;
                    SunburstView.this.repaint();
                    timer.stop();
                }
            };
            if (!this.isAdjusting && !this.needsSimplify && this.needsProgressive) {
                this.dispatcher.dispatch(worker);
            } else {
                worker.run();
            }
        }
        if (this.worker == null) {
            gr.drawImage(this.img, 0, 0, this);
        }
        if (this.selectedNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selectedNode.children().size() == 0) {
                this.draw.drawSubtreeBounds(g, this.selectedNode, Color.red);
            } else {
                this.draw.drawDescendantSubtreeBounds(g, this.selectedNode, Color.red);
            }
        }
        if (this.hoverNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.draw.drawNodeBounds(g, this.hoverNode, Color.black);
            if (this.subDraw != null && this.subDraw.getRoot().isDescendant(this.hoverNode) && (this.hoverNode != this.subDraw.getRoot() || this.subDraw.getRoot().children().size() == 0)) {
                this.subDraw.drawNodeBounds(g, this.hoverNode, Color.BLACK);
            }
        }
        if (this.drawHandles) {
            g = (Graphics2D)gr;
            double cx = this.draw.getCX();
            double cy = this.draw.getCY();
            g.setColor(Color.BLACK);
            AffineTransform t = new AffineTransform();
            t.translate(cx, cy);
            t.rotate(this.draw.getRotation() * Math.PI / -180.0);
            AffineTransform oldT = (AffineTransform)g.getTransform().clone();
            g.setTransform(t);
            g.draw(new Line2D.Double(-5.0, 0.0, 5.0, 0.0));
            g.draw(new Line2D.Double(0.0, -5.0, 0.0, 5.0));
            g.setTransform(oldT);
        }
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        SunburstNode node = this.draw.getNodeAt(x, y = event.getY());
        if (node == null && this.subDraw != null && (node = this.subDraw.getNodeAt(x, y)) == this.subDraw.getRoot() && this.subDraw.getRoot().children().size() != 0) {
            node = null;
        }
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void setSelectedNode(SunburstNode newValue) {
        this.selectedNode = newValue;
        if (this.selectedNode == null) {
            if (this.subDraw != null) {
                this.draw.setOuterRadius(this.subDraw.getOuterRadius());
                this.subDraw = null;
            }
        } else {
            double outerRadius = this.subDraw == null ? this.draw.getOuterRadius() : this.subDraw.getOuterRadius();
            this.subDraw = this.selectedNode.children().size() == 0 ? new SunburstDraw(this.selectedNode, this.draw.getInfo()) : new SunburstDraw(this.selectedNode, this.draw.getInfo());
            this.setRotation(this.draw.getRotation());
            this.setOuterRadius(outerRadius);
            this.setCenter(this.draw.getCX(), this.draw.getCY());
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private double alphaStart;
        private boolean isMove;
        private Point moveStart;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            SunburstNode node = SunburstView.this.draw.getNodeAt(evt.getX(), evt.getY());
            if (node == null && SunburstView.this.subDraw != null && (node = SunburstView.this.subDraw.getNodeAt(evt.getX(), evt.getY())) == SunburstView.this.subDraw.getRoot() && SunburstView.this.subDraw.getRoot().children().size() != 0) {
                node = null;
            }
            if (node == SunburstView.this.draw.getRoot()) {
                SunburstView.this.setSelectedNode(null);
                if (evt.getClickCount() == 2) {
                    SunburstView.this.setCenter(SunburstView.this.getWidth() / 2, SunburstView.this.getHeight() / 2);
                    SunburstView.this.setSelectedNode(null);
                }
            } else {
                SunburstView.this.setSelectedNode(node);
            }
            SunburstView.this.isInvalid = true;
            SunburstView.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            this.isMove = SunburstView.this.draw.getNodeAt(e.getX(), e.getY()) == SunburstView.this.draw.getRoot();
            this.moveStart = e.getPoint();
            this.alphaStart = SunburstView.this.draw.getTheta(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            if (SunburstView.this.drawHandles || SunburstView.this.isAdjusting) {
                SunburstView.this.drawHandles = false;
                if (SunburstView.this.isAdjusting) {
                    SunburstView.this.isAdjusting = false;
                    SunburstView.this.isInvalid = true;
                }
                SunburstView.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (SunburstView.this.drawHandles) {
                SunburstView.this.drawHandles = false;
                SunburstView.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            SunburstView.this.isAdjusting = true;
            if (this.isMove) {
                Point moveNow = e.getPoint();
                int cx = (int)SunburstView.this.draw.getCX();
                int cy = (int)SunburstView.this.draw.getCY();
                SunburstView.this.setCenter(cx + moveNow.x - this.moveStart.x, cy + moveNow.y - this.moveStart.y);
                this.moveStart = moveNow;
                SunburstView.this.isInvalid = true;
                SunburstView.this.repaint();
            } else {
                double alphaNow = SunburstView.this.draw.getTheta(e.getX(), e.getY());
                SunburstView.this.setRotation(SunburstView.this.draw.getRotation() - alphaNow + this.alphaStart);
                SunburstView.this.isInvalid = true;
                SunburstView.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            SunburstView.this.hoverNode = SunburstView.this.draw.getNodeAt(e.getX(), e.getY());
            if (SunburstView.this.hoverNode == null && SunburstView.this.subDraw != null) {
                SunburstView.this.hoverNode = SunburstView.this.subDraw.getNodeAt(e.getX(), e.getY());
                if (SunburstView.this.hoverNode == SunburstView.this.subDraw.getRoot() && SunburstView.this.subDraw.getRoot().children().size() != 0) {
                    SunburstView.this.hoverNode = null;
                }
            }
            SunburstView.this.repaint();
        }
    }
}

