/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunburst;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunburstNode {
    private SunburstNode parent;
    private TreePath2<TreeNode> dataNodePath;
    private long left;
    private long right;
    private int maxDepth = -1;

    public SunburstNode(SunburstNode parent, TreeNode data) {
        this.dataNodePath = parent == null ? new TreePath2(data) : parent.getDataNodePath().pathByAddingChild(data);
        this.parent = parent;
    }

    public TreeNode getNode() {
        return this.dataNodePath.getLastPathComponent();
    }

    public TreePath2<TreeNode> getDataNodePath() {
        return this.dataNodePath;
    }

    public int getMaxDepth() {
        if (this.maxDepth == -1) {
            this.maxDepth = this.getMaxDepth(this, 1);
        }
        return this.maxDepth;
    }

    private int getMaxDepth(SunburstNode node, int depth) {
        int max = depth;
        for (SunburstNode child : node.children()) {
            max = Math.max(max, this.getMaxDepth(child, depth + 1));
        }
        return max;
    }

    public void renumber(NodeInfo info) {
        this.renumber(info, 0, 0);
    }

    private int renumber(NodeInfo info, int depth, int number) {
        if (this.children().size() == 0) {
            this.left = number++;
            this.right = number;
        } else {
            this.left = number;
            for (SunburstNode child : this.children()) {
                number = child.renumber(info, depth + 1, number);
            }
            this.right = number;
        }
        return number;
    }

    public List<SunburstNode> children() {
        return Collections.EMPTY_LIST;
    }

    public void dump() {
        System.out.println(this.getDepth() + "," + this.left + "," + this.right + " " + this.toString());
        for (SunburstNode child : this.children()) {
            child.dump();
        }
    }

    public boolean isLeaf() {
        return !this.dataNodePath.getLastPathComponent().getAllowsChildren();
    }

    public long getLeft() {
        return this.left;
    }

    public long getRight() {
        return this.right;
    }

    public long getExtent() {
        return this.right - this.left;
    }

    public int getDepth() {
        return this.dataNodePath.getPathCount();
    }

    public boolean isDescendant(SunburstNode node) {
        return node.getLeft() >= this.getLeft() && node.getRight() <= this.getRight() && node.getDepth() >= this.getDepth();
    }

    public SunburstNode findNode(int depth, long number) {
        if (this.getLeft() <= number && this.getRight() > number) {
            if (depth == 0) {
                return this;
            }
            for (SunburstNode child : this.children()) {
                SunburstNode found = child.findNode(depth - 1, number);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

