/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunburst;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.sunburst.SunburstNode;
import ch.randelshofer.tree.sunburst.SunburstTree;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class SunburstDraw {
    private double cx = 100.0;
    private double cy = 100.0;
    private double innerRadius = 0.0;
    private double outerRadius = 96.0;
    private SunburstNode root;
    private int totalDepth;
    private double numberToAngleFactor;
    private double rotation;
    private NodeInfo info;

    public SunburstDraw(SunburstTree model) {
        this(model.getRoot(), model.getInfo());
    }

    public SunburstDraw(SunburstNode root, NodeInfo info) {
        this.root = root;
        this.totalDepth = root.getMaxDepth();
        this.numberToAngleFactor = Math.PI * 2 / (double)root.getExtent();
        this.rotation = 0.0;
        this.info = info;
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public SunburstNode getRoot() {
        return this.root;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double newValue) {
        this.rotation = (Math.PI * 2 + newValue) % (Math.PI * 2);
    }

    public int getTotalDepth() {
        return this.totalDepth;
    }

    public double getCX() {
        return this.cx;
    }

    public void setCX(double newValue) {
        this.cx = newValue;
    }

    public double getCY() {
        return this.cy;
    }

    public void setCY(double newValue) {
        this.cy = newValue;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double newValue) {
        this.innerRadius = newValue;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double newValue) {
        this.outerRadius = newValue;
    }

    private double getRadius(int depth) {
        return this.innerRadius + (this.outerRadius - this.innerRadius) * (double)depth / (double)this.totalDepth;
    }

    public double getTheta(double x, double y) {
        return ((Math.atan2(this.cx - x, y - this.cy) + this.rotation) / Math.PI * 180.0 + 360.0) % 360.0 / 180.0 * Math.PI;
    }

    public SunburstNode getNodeAt(int x, int y) {
        double r = Math.sqrt((this.cx - (double)x) * (this.cx - (double)x) + (this.cy - (double)y) * (this.cy - (double)y));
        if (r < this.innerRadius || r > this.outerRadius) {
            return null;
        }
        double theta = this.getTheta(x, y);
        int depth = (int)((r - this.innerRadius) / (this.outerRadius - this.innerRadius) * (double)this.totalDepth);
        long number = (long)(theta / this.numberToAngleFactor) + this.root.getLeft();
        return this.root.findNode(depth, number);
    }

    public String getToolTipText(int x, int y) {
        SunburstNode node = this.getNodeAt(x, y);
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void drawNodeBounds(Graphics2D g, SunburstNode selectedNode, Color color) {
        double ro = this.getRadius(selectedNode.getDepth() - this.root.getDepth() + 1) - 1.0;
        double ri = this.getRadius(selectedNode.getDepth() - this.root.getDepth());
        double startAngle = (double)(selectedNode.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.getRotation();
        double arc = (double)(selectedNode.getRight() - selectedNode.getLeft()) * this.numberToAngleFactor;
        GeneralPath path = SunburstDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
        g.setColor(color);
        g.draw(path);
    }

    public void drawSubtreeBounds(Graphics2D g, SunburstNode selectedNode, Color color) {
        if (selectedNode.isLeaf()) {
            this.drawNodeBounds(g, selectedNode, color);
        } else {
            double ro = this.getRadius(this.totalDepth);
            double ri = this.getRadius(selectedNode.getDepth() - this.root.getDepth());
            double startAngle = (double)(selectedNode.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.getRotation();
            double arc = (double)(selectedNode.getRight() - selectedNode.getLeft()) * this.numberToAngleFactor;
            GeneralPath path = SunburstDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
            g.setColor(color);
            g.draw(path);
        }
    }

    public void drawDescendantSubtreeBounds(Graphics2D g, SunburstNode parent, Color color) {
        double ro = this.getRadius(parent.getDepth() + parent.getMaxDepth());
        double ri = this.getRadius(parent.getDepth() - this.root.getDepth() + 1);
        double startAngle = (double)parent.getLeft() * this.numberToAngleFactor - this.getRotation();
        double arc = (double)(parent.getRight() - parent.getLeft()) * this.numberToAngleFactor;
        GeneralPath path = SunburstDraw.createArc(this.getCX(), this.getCY(), startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro, ri);
        g.setColor(color);
        g.draw(path);
    }

    public static GeneralPath createArc(double x, double y, double startAngle, double arc, double outerRadius, double innerRadius) {
        GeneralPath mc = new GeneralPath();
        double by = 0.0;
        double bx = 0.0;
        if (Math.abs(arc) > 360.0) {
            arc = 360.0;
        }
        double segs = Math.ceil(Math.abs(arc) / 45.0);
        double segAngle_a = arc / segs;
        double segAngle_b = -arc / segs;
        double theta_a = -(segAngle_a / 180.0) * Math.PI;
        double theta_b = -(segAngle_b / 180.0) * Math.PI;
        double angle = -(startAngle / 180.0) * Math.PI;
        if (segs > 0.0) {
            double cy;
            double cx;
            double angleMid;
            double ax = x + Math.sin(-startAngle / 180.0 * Math.PI) * outerRadius;
            double ay = y + Math.cos(startAngle / 180.0 * Math.PI) * outerRadius;
            mc.moveTo((float)ax, (float)ay);
            int i = 0;
            while ((double)i < segs) {
                angleMid = (angle += theta_a) - theta_a / 2.0;
                bx = x + Math.sin(angle) * outerRadius;
                by = y + Math.cos(angle) * outerRadius;
                cx = x + Math.sin(angleMid) * (outerRadius / Math.cos(theta_a / 2.0));
                cy = y + Math.cos(angleMid) * (outerRadius / Math.cos(theta_a / 2.0));
                mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                ++i;
            }
            angle = -((startAngle += arc) / 180.0) * Math.PI;
            double dx = x + Math.sin(-startAngle / 180.0 * Math.PI) * innerRadius;
            double dy = y + Math.cos(startAngle / 180.0 * Math.PI) * innerRadius;
            if (arc < 360.0) {
                mc.lineTo((float)dx, (float)dy);
            } else {
                mc.moveTo((float)dx, (float)dy);
            }
            if (innerRadius > 0.0) {
                i = 0;
                while ((double)i < segs) {
                    angleMid = (angle += theta_b) - theta_b / 2.0;
                    bx = x + Math.sin(angle) * innerRadius;
                    by = y + Math.cos(angle) * innerRadius;
                    cx = x + Math.sin(angleMid) * (innerRadius / Math.cos(theta_b / 2.0));
                    cy = y + Math.cos(angleMid) * (innerRadius / Math.cos(theta_b / 2.0));
                    mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                    ++i;
                }
            }
            if (arc < 360.0) {
                mc.lineTo((float)ax, (float)ay);
            }
        }
        return mc;
    }

    public static void addSeg(GeneralPath mc, double x, double y, double startAngle, double arc, double radius) {
        double by = 0.0;
        double bx = 0.0;
        if (Math.abs(arc) > 360.0) {
            arc = 360.0;
        }
        double segs = Math.ceil(Math.abs(arc) / 45.0);
        double segAngle_a = arc / segs;
        double segAngle_b = -arc / segs;
        double theta_a = -(segAngle_a / 180.0) * Math.PI;
        double theta_b = -(segAngle_b / 180.0) * Math.PI;
        double angle = -(startAngle / 180.0) * Math.PI;
        if (segs > 0.0) {
            double ax = x + Math.sin(-startAngle / 180.0 * Math.PI) * radius;
            double ay = y + Math.cos(startAngle / 180.0 * Math.PI) * radius;
            mc.moveTo((float)ax, (float)ay);
            int i = 0;
            while ((double)i < segs) {
                double angleMid = (angle += theta_a) - theta_a / 2.0;
                bx = x + Math.sin(angle) * radius;
                by = y + Math.cos(angle) * radius;
                double cx = x + Math.sin(angleMid) * (radius / Math.cos(theta_a / 2.0));
                double cy = y + Math.cos(angleMid) * (radius / Math.cos(theta_a / 2.0));
                mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                ++i;
            }
        }
    }

    public void drawTree(Graphics2D g, ProgressObserver p) {
        this.drawTree(g, this.root, p);
    }

    public void drawTree(Graphics2D g, SunburstNode node, ProgressObserver p) {
        this.drawNode(g, node);
        this.drawLabel(g, node);
        for (SunburstNode child : node.children()) {
            this.drawTree(g, child, p);
        }
    }

    public void drawContours(Graphics2D g, SunburstNode node, Color color) {
        GeneralPath path = new GeneralPath();
        this.addArc(path, node);
        g.setColor(color);
        g.draw(path);
    }

    private void addArc(GeneralPath path, SunburstNode node) {
        if (!node.isLeaf()) {
            double ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
            double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
            double arc = (double)node.getExtent() * this.numberToAngleFactor;
            SunburstDraw.addSeg(path, this.cx, this.cy, startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro);
        }
        for (SunburstNode child : node.children()) {
            this.addArc(path, child);
        }
    }

    public void drawDescendants(Graphics2D g, SunburstNode node, ProgressObserver p) {
        for (SunburstNode child : node.children()) {
            this.drawTree(g, child, p);
        }
    }

    public void drawLabel(Graphics2D g, SunburstNode node) {
        double ri = this.getRadius(node.getDepth() - this.root.getDepth());
        double ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double endAngle = (double)(node.getRight() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double arc = (double)node.getExtent() * this.numberToAngleFactor;
        double sx = this.cx + Math.cos(startAngle) * ri;
        double sy = this.cy + Math.sin(-startAngle) * ri;
        double ex = this.cx + Math.cos(endAngle) * ri;
        double ey = this.cy + Math.sin(-endAngle) * ri;
        double seg = Math.sqrt((sx - ex) * (sx - ex) + (sy - ey) * (sy - ey));
        g.setColor(Color.BLACK);
        FontMetrics fm = g.getFontMetrics();
        int fh = fm.getHeight();
        if ((double)fh < seg || arc > Math.PI) {
            double space = ro - ri - 8.0;
            String name = this.info.getName(node.getDataNodePath());
            char[] nameC = name == null ? new char[]{} : name.toCharArray();
            int nameLength = nameC.length;
            int nameWidth = fm.charsWidth(nameC, 0, nameLength);
            while ((double)nameWidth >= space && nameLength > 1) {
                nameC[--nameLength - 1] = 183;
                nameWidth = fm.charsWidth(nameC, 0, nameLength);
            }
            if (nameLength > 1 || nameLength == nameC.length) {
                AffineTransform t = new AffineTransform();
                t.translate(this.cx, this.cy);
                t.rotate((startAngle + endAngle + Math.PI) / 2.0);
                AffineTransform oldT = (AffineTransform)g.getTransform().clone();
                g.setTransform(t);
                g.drawString(new String(nameC, 0, nameLength), (int)ri + 4, fm.getAscent() - fh / 2);
                g.setTransform(oldT);
            }
        }
    }

    public void drawNode(Graphics2D g, SunburstNode node) {
        double ri = this.getRadius(node.getDepth() - this.root.getDepth());
        double ro = this.getRadius(node.getDepth() - this.root.getDepth() + 1);
        double less = node.getExtent() == this.root.getExtent() ? 0.0 : 0.3141592653589793 / ri;
        double startAngle = (double)(node.getLeft() - this.root.getLeft()) * this.numberToAngleFactor - this.rotation;
        double arc = (double)node.getExtent() * this.numberToAngleFactor;
        if (arc < Math.PI * 2 - less && arc > less * 4.0) {
            startAngle += less;
            arc -= less * 2.0;
        }
        GeneralPath path = SunburstDraw.createArc(this.cx, this.cy, startAngle / Math.PI * 180.0, arc / Math.PI * 180.0, ro - 1.0, ri);
        g.setColor(this.info.getColor(node.getDataNodePath()));
        g.fill(path);
    }
}

