/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunburst;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.sunburst.IcicleDraw;
import ch.randelshofer.tree.sunburst.SunburstNode;
import ch.randelshofer.tree.sunburst.SunburstTree;
import ch.randelshofer.tree.sunburst.SunburstViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class IcicleView
extends JPanel
implements SunburstViewer,
TreeView {
    private IcicleDraw draw;
    private IcicleDraw subDraw;
    private BufferedImage img;
    private boolean isInvalid;
    private Thread worker;
    private boolean drawHandles;
    private boolean isAdjusting;
    private boolean needsSimplify;
    private boolean isToolTipVisible = false;
    private SunburstNode selectedNode;
    private SunburstNode hoverNode;
    private NodeInfo info;

    public IcicleView() {
        this.init();
    }

    public IcicleView(SunburstTree model) {
        this.draw = new IcicleDraw(model);
        this.info = model.getInfo();
        this.init();
    }

    private void init() {
        this.initComponents();
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setTreeLocation(double x, double y) {
        this.draw.setX(x);
        this.draw.setY(y);
        this.subDraw.setX(x + this.draw.getWidth() + this.draw.getWidth() / (double)this.draw.getTotalDepth());
        this.subDraw.setY(y);
    }

    public void setTreeBounds(double x, double y, double width, double height) {
        if (this.subDraw == null) {
            this.draw.setX(x);
            this.draw.setY(y);
            this.draw.setWidth(width);
            this.draw.setHeight(height);
        } else {
            this.draw.setX(x);
            this.draw.setY(y);
            this.draw.setWidth(width / 2.0 - width / 2.0 / (double)this.draw.getTotalDepth());
            this.draw.setHeight(height);
            if (this.subDraw.getRoot().isLeaf()) {
                this.subDraw.setX(x + width / 2.0);
                this.subDraw.setWidth(width / 2.0);
            } else {
                this.subDraw.setX(x + width / 2.0 - width / 2.0 / (double)(this.subDraw.getTotalDepth() - 1));
                this.subDraw.setWidth(width / 2.0 + width / 2.0 / (double)(this.subDraw.getTotalDepth() - 1));
            }
            this.subDraw.setY(y);
            this.subDraw.setHeight(height);
        }
    }

    public void setMaxDepth(int newValue) {
    }

    public int getMaxDepth() {
        return Integer.MAX_VALUE;
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            if (this.img == null) {
                this.setTreeBounds(4.0, 4.0, this.getWidth() - 8, this.getHeight() - 8);
            } else {
                this.setTreeBounds(4.0, 4.0, this.getWidth() - 8, this.getHeight() - 8);
            }
            this.img = null;
            this.img = new BufferedImage(w, h, 1);
            this.isInvalid = true;
        }
        if (this.isInvalid) {
            this.isInvalid = false;
            g = this.img.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setBackground(Color.WHITE);
            g.setFont(this.getFont());
            g.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
            if (this.isAdjusting && this.needsSimplify) {
                this.draw.drawContours(g, this.draw.getRoot(), Color.gray);
                if (this.subDraw != null) {
                    this.subDraw.drawContours(g, this.subDraw.getRoot(), Color.gray);
                }
            } else {
                long end;
                long start = System.currentTimeMillis();
                this.draw.drawTree(g);
                if (this.subDraw != null) {
                    if (this.subDraw.getRoot().children().size() == 0) {
                        this.subDraw.drawTree(g);
                    } else {
                        this.subDraw.drawDescendants(g, this.subDraw.getRoot());
                    }
                }
                this.needsSimplify = (end = System.currentTimeMillis()) - start > 500L;
            }
            g.dispose();
        }
        if (this.worker == null) {
            gr.drawImage(this.img, 0, 0, this);
        }
        if (this.selectedNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selectedNode.children().size() == 0) {
                this.draw.drawSubtreeBounds(g, this.selectedNode, Color.red);
            } else {
                this.draw.drawDescendantSubtreeBounds(g, this.selectedNode, Color.red);
            }
        }
        if (this.hoverNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.draw.drawNodeBounds(g, this.hoverNode, Color.black);
            if (this.subDraw != null && this.subDraw.getRoot().isDescendant(this.hoverNode) && (this.hoverNode != this.subDraw.getRoot() || this.subDraw.getRoot().children().size() == 0)) {
                this.subDraw.drawNodeBounds(g, this.hoverNode, Color.BLACK);
            }
        }
        if (this.drawHandles) {
            g = (Graphics2D)gr;
            double cx = this.draw.getX();
            double cy = this.draw.getY();
            g.setColor(Color.BLACK);
            AffineTransform t = new AffineTransform();
            t.translate(cx, cy);
            AffineTransform oldT = (AffineTransform)g.getTransform().clone();
            g.setTransform(t);
            g.draw(new Line2D.Double(-5.0, 0.0, 5.0, 0.0));
            g.draw(new Line2D.Double(0.0, -5.0, 0.0, 5.0));
            g.setTransform(oldT);
        }
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        SunburstNode node = this.draw.getNodeAt(x, y = event.getY());
        if (node == null && this.subDraw != null && (node = this.subDraw.getNodeAt(x, y)) == this.subDraw.getRoot() && this.subDraw.getRoot().children().size() != 0) {
            node = null;
        }
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void setSelectedNode(SunburstNode newValue) {
        this.selectedNode = newValue;
        if (this.selectedNode == null) {
            if (this.subDraw != null) {
                this.draw.setWidth(this.subDraw.getX() + this.subDraw.getWidth() - this.draw.getX());
                this.subDraw = null;
            }
        } else {
            this.subDraw = this.selectedNode.children().size() == 0 ? new IcicleDraw(this.selectedNode, this.draw.getInfo()) : new IcicleDraw(this.selectedNode, this.draw.getInfo());
            this.setTreeBounds(4.0, 4.0, this.getWidth() - 8, this.getHeight() - 8);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private double alphaStart;
        private boolean isMove;
        private Point moveStart;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            SunburstNode node = IcicleView.this.draw.getNodeAt(evt.getX(), evt.getY());
            if (node == null && IcicleView.this.subDraw != null && (node = IcicleView.this.subDraw.getNodeAt(evt.getX(), evt.getY())) == IcicleView.this.subDraw.getRoot() && IcicleView.this.subDraw.getRoot().children().size() != 0) {
                node = null;
            }
            if (node == IcicleView.this.draw.getRoot()) {
                IcicleView.this.setSelectedNode(null);
                if (evt.getClickCount() == 2) {
                    IcicleView.this.setTreeBounds(4.0, 4.0, IcicleView.this.getWidth() - 8, IcicleView.this.getHeight() - 8);
                    IcicleView.this.setSelectedNode(null);
                }
            } else {
                IcicleView.this.setSelectedNode(node);
            }
            IcicleView.this.isInvalid = true;
            IcicleView.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            this.isMove = IcicleView.this.draw.getNodeAt(e.getX(), e.getY()) == IcicleView.this.draw.getRoot();
            this.moveStart = e.getPoint();
            this.alphaStart = IcicleView.this.draw.getTheta(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            if (IcicleView.this.drawHandles || IcicleView.this.isAdjusting) {
                IcicleView.this.drawHandles = false;
                if (IcicleView.this.isAdjusting) {
                    IcicleView.this.isAdjusting = false;
                    IcicleView.this.isInvalid = true;
                }
                IcicleView.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (IcicleView.this.drawHandles) {
                IcicleView.this.drawHandles = false;
                IcicleView.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            IcicleView.this.isAdjusting = true;
            if (this.isMove) {
                Point moveNow = e.getPoint();
                int cx = (int)IcicleView.this.draw.getX();
                int cy = (int)IcicleView.this.draw.getY();
                IcicleView.this.setTreeLocation(cx + moveNow.x - this.moveStart.x, cy + moveNow.y - this.moveStart.y);
                this.moveStart = moveNow;
                IcicleView.this.isInvalid = true;
                IcicleView.this.repaint();
            } else {
                double alphaNow = IcicleView.this.draw.getTheta(e.getX(), e.getY());
                IcicleView.this.isInvalid = true;
                IcicleView.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            IcicleView.this.hoverNode = IcicleView.this.draw.getNodeAt(e.getX(), e.getY());
            if (IcicleView.this.hoverNode == null && IcicleView.this.subDraw != null) {
                IcicleView.this.hoverNode = IcicleView.this.subDraw.getNodeAt(e.getX(), e.getY());
                if (IcicleView.this.hoverNode == IcicleView.this.subDraw.getRoot() && IcicleView.this.subDraw.getRoot().children().size() != 0) {
                    IcicleView.this.hoverNode = null;
                }
            }
            IcicleView.this.repaint();
        }
    }
}

