/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.sunburst;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.sunburst.SunburstNode;
import ch.randelshofer.tree.sunburst.SunburstTree;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class IcicleDraw {
    private double cx = 100.0;
    private double cy = 100.0;
    private double width = 96.0;
    private double height = 96.0;
    private SunburstNode root;
    private int totalDepth;
    private double numberToAngleFactor;
    private NodeInfo info;

    public IcicleDraw(SunburstTree model) {
        this(model.getRoot(), model.getInfo());
    }

    public IcicleDraw(SunburstNode root, NodeInfo info) {
        this.root = root;
        this.totalDepth = root.getMaxDepth();
        this.numberToAngleFactor = Math.PI * 2 / (double)root.getExtent();
        this.info = info;
    }

    public SunburstNode getRoot() {
        return this.root;
    }

    public int getTotalDepth() {
        return this.totalDepth;
    }

    public double getX() {
        return this.cx;
    }

    public void setX(double newValue) {
        this.cx = newValue;
    }

    public double getY() {
        return this.cy;
    }

    public void setY(double newValue) {
        this.cy = newValue;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double newValue) {
        this.width = newValue;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double newValue) {
        this.height = newValue;
    }

    public SunburstNode getNodeAt(int x, int y) {
        int depth = (int)(((double)x - this.cx) / this.width * (double)this.getTotalDepth());
        long number = (long)(((double)y - this.cy) / this.height * (double)this.root.getExtent()) + this.root.getLeft();
        return this.root.findNode(depth, number);
    }

    public String getToolTipText(int x, int y) {
        SunburstNode node = this.getNodeAt(x, y);
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    public void drawNodeBounds(Graphics2D g, SunburstNode node, Color color) {
        double h = this.height * (double)node.getExtent() / (double)this.root.getExtent();
        double less = h > 2.0 && node.getExtent() < this.root.getExtent() ? 0.5 : 0.0;
        Rectangle2D.Double r = new Rectangle2D.Double(this.cx + this.width * (double)(node.getDepth() - this.root.getDepth()) / (double)this.totalDepth, this.cy + this.height * (double)(node.getLeft() - this.root.getLeft()) / (double)this.root.getExtent() + less, this.width / (double)this.totalDepth - 1.0, this.height * (double)node.getExtent() / (double)this.root.getExtent() - less * 2.0);
        g.setColor(color);
        g.draw(r);
    }

    public void drawSubtreeBounds(Graphics2D g, SunburstNode node, Color color) {
        double h = this.height * (double)node.getExtent() / (double)this.root.getExtent();
        double less = h > 2.0 && node.getExtent() < this.root.getExtent() ? 0.5 : 0.0;
        Rectangle2D.Double r = new Rectangle2D.Double(this.cx + this.width * (double)node.getDepth() / (double)this.totalDepth, this.cy + this.height * (double)node.getLeft() / (double)this.root.getExtent() + less, this.width - this.width * (double)node.getDepth() / (double)this.totalDepth, this.height * (double)node.getExtent() / (double)this.root.getExtent() - less * 2.0);
        g.setColor(color);
        g.draw(r);
    }

    public void drawDescendantSubtreeBounds(Graphics2D g, SunburstNode node, Color color) {
        if (node.isLeaf()) {
            this.drawNodeBounds(g, node, color);
        } else {
            double h = this.height * (double)node.getExtent() / (double)this.root.getExtent();
            double less = h > 2.0 && node.getExtent() < this.root.getExtent() ? 0.5 : 0.0;
            Rectangle2D.Double r = new Rectangle2D.Double(this.cx + this.width * (double)(node.getDepth() + 1) / (double)this.totalDepth, this.cy + this.height * (double)node.getLeft() / (double)this.root.getExtent() + less, this.getRadius(node.getDepth() + node.getMaxDepth()) - this.getRadius(node.getDepth() + 1), this.height * (double)node.getExtent() / (double)this.root.getExtent() - less * 2.0);
            g.setColor(color);
            g.draw(r);
        }
    }

    public static Rectangle2D.Double createArc(double x, double y, double startAngle, double arc, double outerRadius, double innerRadius) {
        Rectangle2D.Double rec = new Rectangle2D.Double(x + innerRadius, y + startAngle, outerRadius - innerRadius, arc);
        return rec;
    }

    public static void addSeg(GeneralPath mc, double x, double y, double startAngle, double arc, double radius) {
        double by = 0.0;
        double bx = 0.0;
        if (Math.abs(arc) > 360.0) {
            arc = 360.0;
        }
        double segs = Math.ceil(Math.abs(arc) / 45.0);
        double segAngle_a = arc / segs;
        double segAngle_b = -arc / segs;
        double theta_a = -(segAngle_a / 180.0) * Math.PI;
        double theta_b = -(segAngle_b / 180.0) * Math.PI;
        double angle = -(startAngle / 180.0) * Math.PI;
        if (segs > 0.0) {
            double ax = x + Math.sin(-startAngle / 180.0 * Math.PI) * radius;
            double ay = y + Math.cos(startAngle / 180.0 * Math.PI) * radius;
            mc.moveTo((float)ax, (float)ay);
            int i = 0;
            while ((double)i < segs) {
                double angleMid = (angle += theta_a) - theta_a / 2.0;
                bx = x + Math.sin(angle) * radius;
                by = y + Math.cos(angle) * radius;
                double cx = x + Math.sin(angleMid) * (radius / Math.cos(theta_a / 2.0));
                double cy = y + Math.cos(angleMid) * (radius / Math.cos(theta_a / 2.0));
                mc.quadTo((float)cx, (float)cy, (float)bx, (float)by);
                ++i;
            }
        }
    }

    public void drawTree(Graphics2D g) {
        this.drawTree(g, this.root);
    }

    public void drawTree(Graphics2D g, SunburstNode node) {
        this.drawNode(g, node);
        this.drawLabel(g, node);
        for (SunburstNode child : node.children()) {
            this.drawTree(g, child);
        }
    }

    public void drawContours(Graphics2D g, SunburstNode node, Color color) {
        GeneralPath path = new GeneralPath();
        this.addArc(path, node);
        g.setColor(color);
        g.draw(path);
    }

    private void addArc(GeneralPath path, SunburstNode node) {
    }

    public void drawDescendants(Graphics2D g, SunburstNode node) {
        for (SunburstNode child : node.children()) {
            this.drawTree(g, child);
        }
    }

    private double getRadius(int depth) {
        return this.cx + this.width * (double)depth / (double)this.totalDepth;
    }

    public double getTheta(double x, double y) {
        if (y < this.cy || y > this.cy + this.height) {
            return 0.0;
        }
        return (y - this.cy) * 360.0 / this.height;
    }

    public void drawLabel(Graphics2D g, SunburstNode node) {
        double h = this.height * (double)node.getExtent() / (double)this.root.getExtent();
        double less = h > 2.0 && node.getExtent() < this.root.getExtent() ? 0.5 : 0.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(this.cx + this.width * (double)(node.getDepth() - this.root.getDepth()) / (double)this.totalDepth, this.cy + this.height * (double)(node.getLeft() - this.root.getLeft()) / (double)this.root.getExtent() + less, this.width / (double)this.totalDepth - 1.0, this.height * (double)node.getExtent() / (double)this.root.getExtent() - less * 2.0);
        g.setColor(this.info.getColor(node.getDataNodePath()));
        FontMetrics fm = g.getFontMetrics();
        int fh = fm.getHeight();
        if ((double)fh < rec.height) {
            double space = rec.width - 4.0;
            String name = this.info.getName(node.getDataNodePath());
            char[] nameC = name == null ? new char[]{} : name.toCharArray();
            int nameLength = nameC.length;
            int nameWidth = fm.charsWidth(nameC, 0, nameLength);
            while ((double)nameWidth >= space && nameLength > 1) {
                nameC[--nameLength - 1] = 183;
                nameWidth = fm.charsWidth(nameC, 0, nameLength);
            }
            if (nameLength > 1 || nameLength == nameC.length) {
                g.setColor(Color.BLACK);
                g.drawString(new String(nameC, 0, nameLength), (int)rec.x + 4, (int)(rec.y + (double)fm.getAscent() + (rec.height - (double)fh) / 2.0));
            }
        }
    }

    public void drawNode(Graphics2D g, SunburstNode node) {
        double h = this.height * (double)node.getExtent() / (double)this.root.getExtent();
        double less = h > 2.0 && node.getExtent() < this.root.getExtent() ? 0.5 : 0.0;
        Rectangle2D.Double r = new Rectangle2D.Double(this.cx + this.width * (double)(node.getDepth() - this.root.getDepth()) / (double)this.totalDepth, this.cy + this.height * (double)(node.getLeft() - this.root.getLeft()) / (double)this.root.getExtent() + less, this.width / (double)this.totalDepth - 1.0, this.height * (double)node.getExtent() / (double)this.root.getExtent() - less * 2.0);
        g.setColor(this.info.getColor(node.getDataNodePath()));
        g.fill(r);
    }

    public NodeInfo getInfo() {
        return this.info;
    }
}

