/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.rectmap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressTracker;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.rectmap.RectmapDraw;
import ch.randelshofer.tree.rectmap.RectmapNode;
import ch.randelshofer.tree.rectmap.RectmapTree;
import ch.randelshofer.util.SequentialDispatcher;
import ch.randelshofer.util.Worker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RectmapView
extends JPanel
implements TreeView {
    private RectmapDraw draw;
    private BufferedImage img;
    private boolean isInvalid;
    private ProgressObserver workerProgress;
    private boolean drawHandles;
    private boolean isAdjusting;
    private boolean needsSimplify;
    private boolean needsProgressive = true;
    private RectmapNode hoverNode;
    private NodeInfo info;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private boolean isToolTipVisible = false;

    public RectmapView() {
    }

    public RectmapView(RectmapTree model) {
        this.info = model.getInfo();
        this.draw = new RectmapDraw(model.getRoot(), model.getInfo());
        this.init();
        model.getInfo().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RectmapView.this.isInvalid = true;
                RectmapView.this.repaint();
            }
        });
    }

    private void init() {
        this.initComponents();
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        RectmapNode node = this.draw.getNodeAt(x, y = event.getY());
        return node == null ? null : this.info.getTooltip(node.getDataNodePath());
    }

    private void setDrawPosition(double cx, double cy) {
        this.draw.setX(cx);
        this.draw.setY(cy);
    }

    private void setDrawSize(double w, double h) {
        this.draw.setWidth(w);
        this.draw.setHeight(h);
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g;
        int w = this.getWidth();
        int h = this.getHeight();
        this.setDrawPosition(2.0, 2.0);
        this.setDrawSize(w - 4, h - 4);
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            this.img = null;
            this.img = new BufferedImage(w, h, 1);
            Graphics2D g2 = this.img.createGraphics();
            g2.setBackground(Color.WHITE);
            g2.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
            g2.dispose();
            this.isInvalid = true;
        }
        if (this.isInvalid) {
            if (this.workerProgress != null) {
                this.workerProgress.cancel();
            } else {
                this.isInvalid = false;
                final BufferedImage workingImage = this.img;
                this.workerProgress = new ProgressTracker("Rectangular Treemap", "Drawing...");
                this.workerProgress.setIndeterminate(true);
                final Timer timer = new Timer(33, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RectmapView.this.repaint();
                    }
                });
                timer.isRepeats();
                timer.start();
                Worker worker = new Worker(){

                    public Object construct() {
                        Graphics2D g = workingImage.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setBackground(Color.WHITE);
                        g.setFont(RectmapView.this.getFont());
                        g.clearRect(0, 0, workingImage.getWidth(), workingImage.getHeight());
                        g.setClip(new Rectangle(0, 0, workingImage.getWidth(), workingImage.getHeight()));
                        if (RectmapView.this.isAdjusting && RectmapView.this.needsSimplify) {
                            RectmapView.this.draw.drawTree(g, RectmapView.this.workerProgress);
                        } else {
                            long start = System.currentTimeMillis();
                            RectmapView.this.draw.drawTree(g, RectmapView.this.workerProgress);
                            long end = System.currentTimeMillis();
                            RectmapView.this.needsSimplify = end - start > 99L;
                            RectmapView.this.needsProgressive = end - start > 33L;
                        }
                        g.dispose();
                        return null;
                    }

                    public void done(Object value) {
                        RectmapView.this.workerProgress.close();
                        RectmapView.this.workerProgress = null;
                        RectmapView.this.repaint();
                        timer.stop();
                    }
                };
                if (this.needsProgressive) {
                    this.dispatcher.dispatch(worker);
                } else {
                    worker.run();
                }
            }
        }
        gr.drawImage(this.img, 0, 0, this);
        RectmapNode selectedNode = this.draw.getDrawRoot();
        if (selectedNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.hoverNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RectmapNode node = this.hoverNode;
            while ((node = node.getParent()) != null) {
                this.draw.drawNodeBounds(g, node, Color.blue);
            }
            this.draw.drawNodeBounds(g, this.hoverNode, Color.red);
        }
        if (this.drawHandles) {
            g = (Graphics2D)gr;
            double cx = this.draw.getX();
            double cy = this.draw.getY();
            g.setColor(Color.BLACK);
            AffineTransform t = new AffineTransform();
            t.translate(cx, cy);
            AffineTransform oldT = (AffineTransform)g.getTransform().clone();
            g.setTransform(t);
            g.draw(new Line2D.Double(-5.0, 0.0, 5.0, 0.0));
            g.draw(new Line2D.Double(0.0, -5.0, 0.0, 5.0));
            g.setTransform(oldT);
        }
    }

    public void setMaxDepth(int newValue) {
        if (newValue != this.draw.getMaxDepth()) {
            this.draw.setMaxDepth(newValue);
            this.isInvalid = true;
            if (newValue == Integer.MAX_VALUE) {
                this.needsProgressive = true;
            }
            this.repaint();
        }
    }

    public int getMaxDepth() {
        return this.draw.getMaxDepth();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            RectmapNode node = RectmapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            if (node == RectmapView.this.draw.getDrawRoot()) {
                node = RectmapView.this.draw.getRoot();
            }
            if (node != RectmapView.this.draw.getDrawRoot()) {
                RectmapView.this.draw.setDrawRoot(node == null || node == RectmapView.this.draw.getDrawRoot() ? RectmapView.this.draw.getRoot() : node);
                RectmapView.this.isInvalid = true;
                RectmapView.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent evt) {
            RectmapView.this.hoverNode = RectmapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            RectmapView.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            RectmapView.this.hoverNode = null;
            RectmapView.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent evt) {
            RectmapView.this.hoverNode = RectmapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            RectmapView.this.repaint();
        }
    }
}

