/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.rectmap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectmapNode
extends Rectangle2D.Double {
    protected RectmapNode parent;
    protected TreePath2<TreeNode> dataNodePath;
    protected double cumulatedWeight = -1.0;

    public RectmapNode(RectmapNode parent, TreeNode data) {
        this.parent = parent;
        this.dataNodePath = parent == null ? new TreePath2(data) : parent.getDataNodePath().pathByAddingChild(data);
    }

    public List<RectmapNode> children() {
        return Collections.EMPTY_LIST;
    }

    public boolean isLeaf() {
        return true;
    }

    public TreePath2<TreeNode> getDataNodePath() {
        return this.dataNodePath;
    }

    public void layout(ProgressObserver p) {
        if (this.parent == null) {
            this.width = this.height = Math.max(1.0, Math.sqrt(this.getCumulatedWeight()));
            this.y = 0.0;
            this.x = 0.0;
        }
    }

    public RectmapNode getParent() {
        return this.parent;
    }

    public void updateCumulatedWeight(NodeInfo info) {
        this.cumulatedWeight = Math.max(1L, info.getWeight(this.dataNodePath));
    }

    public double getCumulatedWeight() {
        return this.cumulatedWeight;
    }

    public int getDescendantCount() {
        return 0;
    }

    @Override
    public String toString() {
        return this.dataNodePath.getLastPathComponent() + " [x:" + this.x + ",y:" + this.y + ",w:" + this.width + ",h:" + this.height + "]";
    }
}

