/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.rectmap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.rectmap.RectmapNode;
import ch.randelshofer.tree.rectmap.RectmapTree;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class RectmapDraw {
    private RectmapNode root;
    private RectmapNode drawRoot;
    private NodeInfo info;
    private Insets insets = new Insets(10, 10, 10, 10);
    private double cx = 2.0;
    private double cy = 2.0;
    private double cwidth = 96.0;
    private double cheight = 96.0;
    private double scaleFactorH = 1.0;
    private double scaleFactorV = 1.0;
    private int maxDepth = Integer.MAX_VALUE;

    public RectmapDraw(RectmapTree model) {
        this(model.getRoot(), model.getInfo());
    }

    public RectmapDraw(RectmapNode root, NodeInfo info) {
        this.root = root;
        this.drawRoot = root;
        this.info = info;
        this.setMaxDepth(1);
    }

    public double getX() {
        return this.cx;
    }

    public void setX(double newValue) {
        this.cx = newValue;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int newValue) {
        this.maxDepth = newValue;
    }

    public double getY() {
        return this.cy;
    }

    public void setY(double newValue) {
        this.cy = newValue;
    }

    public double getWidth() {
        return this.cwidth;
    }

    public void setWidth(double newValue) {
        this.cwidth = newValue;
    }

    public double getHeight() {
        return this.cheight;
    }

    public void setHeight(double newValue) {
        this.cheight = newValue;
    }

    public void drawTree(Graphics2D g, ProgressObserver p) {
        this.scaleFactorH = (this.cwidth - (double)this.insets.left - (double)this.insets.right) / this.drawRoot.getWidth();
        this.scaleFactorV = (this.cheight - (double)this.insets.top - (double)this.insets.bottom) / this.drawRoot.getHeight();
        double sx = 0.0;
        double sy = 0.0;
        RectmapNode node = this.drawRoot;
        int depth = 1;
        while (node != null) {
            sx -= node.getX();
            sy -= node.getY();
            node = node.getParent();
            --depth;
        }
        this.drawTree0(g, this.root, depth, sx + (double)this.insets.left / this.scaleFactorH, sy + (double)this.insets.top / this.scaleFactorV, this.scaleFactorH, this.scaleFactorV, p);
    }

    public void drawTree0(Graphics2D g, RectmapNode node, int depth, double px, double py, double pwidth, double pheight, ProgressObserver p) {
        if (!p.isCanceled()) {
            this.drawNode(g, node, depth, px, py, pwidth, pheight);
            this.drawLabel(g, node, depth, px, py, pwidth, pheight);
            Rectangle2D.Double rect = new Rectangle2D.Double(px * pwidth + this.cx, py * pheight + this.cy, node.width * pwidth, node.height * pheight);
            if (depth < this.maxDepth && rect.width > 1.0 && rect.height > 1.0 && (g.getClipBounds() == null || g.getClipBounds().intersects(rect))) {
                for (RectmapNode child : node.children()) {
                    this.drawTree0(g, child, depth + 1, px + child.getX(), py + child.getY(), pwidth, pheight, p);
                }
            }
        }
    }

    public void drawNode(Graphics2D g, RectmapNode node, int depth, double px, double py, double sfh, double sfv) {
        Rectangle2D.Double rect = new Rectangle2D.Double(px * sfh + this.cx, py * sfv + this.cy, node.width * sfh, node.height * sfv);
        rect.x += 1.0;
        rect.width -= 2.0;
        rect.y += 1.0;
        rect.height -= 2.0;
        if (rect.width > 0.0 && rect.height > 0.0) {
            Color c = this.info.getColor(node.getDataNodePath());
            g.setColor(c);
            g.fill(rect);
            g.setColor(c.brighter());
            g.draw(new Line2D.Double(rect.x, rect.y, rect.x + rect.width - 1.0, rect.y));
            g.draw(new Line2D.Double(rect.x, rect.y, rect.x, rect.y + rect.height - 1.0));
            g.setColor(c.darker());
            g.draw(new Line2D.Double(rect.x, rect.y + rect.height - 1.0, rect.x + rect.width - 1.0, rect.y + rect.height - 1.0));
            g.draw(new Line2D.Double(rect.x + rect.width - 1.0, rect.y, rect.x + rect.width - 1.0, rect.y + rect.height - 1.0));
        }
    }

    public void drawLabel(Graphics2D g, RectmapNode node, int depth, double px, double py, double sfh, double sfv) {
        if (node.children().size() == 0 || depth == this.maxDepth) {
            Rectangle2D.Double rect = new Rectangle2D.Double(px * sfh + this.cx, py * sfv + this.cy, node.width * sfh, node.height * sfv);
            FontMetrics fm = g.getFontMetrics();
            int fh = fm.getHeight();
            if ((double)fh < rect.height) {
                int nameWidth;
                int nameLength;
                char[] nameC;
                String name;
                String weightStr;
                int weightWidth;
                g.setColor(Color.BLACK);
                double space = rect.width - 6.0;
                int y = (int)(rect.y + (rect.height - (double)fh) / 2.0) + fm.getAscent();
                if ((double)(fh * 2) < rect.height && (double)(weightWidth = fm.stringWidth(weightStr = this.info.getWeightFormatted(node.getDataNodePath()))) < space) {
                    g.drawString(weightStr, (int)(rect.x + (rect.width - (double)weightWidth) / 2.0), y + fh / 2);
                    y -= fh / 2;
                }
                if (node.children().size() == 0) {
                    name = this.info.getName(node.getDataNodePath());
                    nameC = name.toCharArray();
                    nameLength = nameC.length;
                    nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    while ((double)nameWidth >= space && nameLength > 1) {
                        nameC[--nameLength - 1] = 183;
                        nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    }
                } else {
                    name = this.info.getName(node.getDataNodePath()) + "\u203a";
                    nameC = name.toCharArray();
                    nameLength = nameC.length;
                    nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    while ((double)nameWidth >= space && nameLength > 1) {
                        nameC[--nameLength - 1] = 8250;
                        nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    }
                }
                if (nameLength > 1 || nameLength == nameC.length) {
                    g.drawString(new String(nameC, 0, nameLength), (int)(rect.x + (rect.width - (double)nameWidth) / 2.0), y);
                }
            }
        }
    }

    public void drawContours(Graphics2D g, RectmapNode node, Color color) {
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public RectmapNode getRoot() {
        return this.root;
    }

    public RectmapNode getDrawRoot() {
        return this.drawRoot;
    }

    public void setDrawRoot(RectmapNode newValue) {
        this.drawRoot = newValue;
    }

    public void drawNodeBounds(Graphics2D g, RectmapNode selectedNode, Color color) {
        RectmapNode node;
        g.setColor(color);
        double scx = 0.0;
        double scy = 0.0;
        for (node = selectedNode; node != null; node = node.getParent()) {
            scx += node.getX();
            scy += node.getY();
        }
        for (node = this.drawRoot; node != null; node = node.getParent()) {
            scx -= node.getX();
            scy -= node.getY();
        }
        double px = scx * this.scaleFactorH + this.cx + (double)this.insets.left;
        double py = scy * this.scaleFactorV + this.cy + (double)this.insets.top;
        Rectangle2D.Double rect = new Rectangle2D.Double(px, py, selectedNode.width * this.scaleFactorH - 2.0, selectedNode.height * this.scaleFactorV - 2.0);
        g.draw(rect);
    }

    public RectmapNode getNodeAt(int px, int py) {
        return this.getNodeAt(((double)px - this.cx - (double)this.insets.left) / this.scaleFactorH, ((double)py - this.cy - (double)this.insets.top) / this.scaleFactorV);
    }

    public RectmapNode getNodeAt(double px, double py) {
        RectmapNode parent = this.drawRoot;
        int depth = 1;
        while (parent != null) {
            px += parent.getX();
            py += parent.getY();
            parent = parent.getParent();
            --depth;
        }
        Rectangle2D.Double slimmed = new Rectangle2D.Double();
        if (this.root.contains(px, py)) {
            RectmapNode found;
            parent = found = this.root;
            block1: do {
                parent = found;
                px -= parent.x;
                py -= parent.y;
                for (RectmapNode node : parent.children()) {
                    slimmed.setRect(node.x + 1.0 / this.scaleFactorH, node.y + 1.0 / this.scaleFactorV, node.width - 2.0 / this.scaleFactorH, node.height - 2.0 / this.scaleFactorV);
                    if (!slimmed.contains(px, py)) continue;
                    found = node;
                    ++depth;
                    continue block1;
                }
            } while (found != parent && depth < this.maxDepth);
            return found;
        }
        return null;
    }
}

