/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.rectmap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.rectmap.RectmapCumulatedSizeComparator;
import ch.randelshofer.tree.rectmap.RectmapNode;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectmapCompositeNode
extends RectmapNode {
    private ArrayList<RectmapNode> children = new ArrayList();
    private int descendants = -1;

    public RectmapCompositeNode(RectmapNode parent, TreeNode data) {
        super(parent, data);
        for (TreeNode c : data.children()) {
            RectmapNode n;
            if (!c.getAllowsChildren()) {
                n = new RectmapNode(this, c);
                this.children.add(n);
                continue;
            }
            n = new RectmapCompositeNode(this, c);
            this.children.add(n);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<RectmapNode> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void updateCumulatedWeight(NodeInfo info) {
        this.cumulatedWeight = 0.0;
        for (RectmapNode node : this.children) {
            node.updateCumulatedWeight(info);
            this.cumulatedWeight += node.getCumulatedWeight();
        }
        this.cumulatedWeight = Math.max(1.0, this.cumulatedWeight);
    }

    @Override
    public void layout(ProgressObserver p) {
        super.layout(p);
        if (this.children.size() > 0) {
            ArrayList<RectmapNode> remaining = new ArrayList<RectmapNode>(this.children);
            Collections.sort(remaining, RectmapCumulatedSizeComparator.getDescendingInstance());
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
            this.squarify(remaining, 0, rect);
            for (RectmapNode child : this.children) {
                child.layout(p);
            }
            p.setProgress(p.getProgress() + this.children.size());
        }
    }

    private void squarify(ArrayList<RectmapNode> nodes, int start, Rectangle2D.Double rect) {
        while (start < nodes.size()) {
            if (rect.width >= rect.height) {
                start = this.layoutColumn(nodes, start, rect);
                continue;
            }
            start = this.layoutRow(nodes, start, rect);
        }
    }

    private int layoutColumn(ArrayList<RectmapNode> nodes, int start, Rectangle2D.Double rect) {
        double newRatio;
        int to;
        double ratio = this.worstAspectRatio(nodes, start, start, rect.height);
        double totalWeight = nodes.get(start).getCumulatedWeight();
        for (to = start + 1; to < nodes.size() && !((newRatio = this.worstAspectRatio(nodes, start, to, rect.height)) > ratio); ++to) {
            ratio = newRatio;
            totalWeight += nodes.get(to).getCumulatedWeight();
        }
        double ny = rect.y;
        double nw = totalWeight / rect.height;
        for (int i = start; i < to; ++i) {
            RectmapNode node = nodes.get(i);
            node.width = nw;
            node.height = node.getCumulatedWeight() / nw;
            node.x = rect.x;
            node.y = ny;
            ny += node.height;
        }
        rect.x += nw;
        rect.width -= nw;
        return to;
    }

    private int layoutRow(ArrayList<RectmapNode> nodes, int start, Rectangle2D.Double rect) {
        double newRatio;
        int to;
        double ratio = this.worstAspectRatio(nodes, start, start, rect.width);
        double totalWeight = nodes.get(start).getCumulatedWeight();
        for (to = start + 1; to < nodes.size() && !((newRatio = this.worstAspectRatio(nodes, start, to, rect.width)) > ratio); ++to) {
            ratio = newRatio;
            totalWeight += nodes.get(to).getCumulatedWeight();
        }
        double nx = rect.x;
        double nh = totalWeight / rect.width;
        for (int i = start; i < to; ++i) {
            RectmapNode node = nodes.get(i);
            node.height = nh;
            node.width = node.getCumulatedWeight() / nh;
            node.x = nx;
            node.y = rect.y + rect.height - nh;
            nx += node.width;
        }
        rect.height -= nh;
        return to;
    }

    private double worstAspectRatio(ArrayList<RectmapNode> nodes, int from, int to, double w) {
        double s = 0.0;
        double rmax = Double.MIN_VALUE;
        double rmin = Double.MAX_VALUE;
        for (int i = from; i <= to; ++i) {
            double nodeWeight = nodes.get(i).getCumulatedWeight();
            s += nodeWeight;
            rmax = Math.max(rmax, nodeWeight);
            rmin = Math.min(rmin, nodeWeight);
        }
        return Math.max(w * w * rmax / (s * s), s * s / (w * w * rmin));
    }

    @Override
    public int getDescendantCount() {
        if (this.descendants == -1) {
            this.descendants += this.children.size();
            for (RectmapNode child : this.children) {
                this.descendants += child.getDescendantCount();
            }
        }
        return this.descendants;
    }
}

