/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.hypertree.HTAction;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDraw;
import ch.randelshofer.tree.hypertree.HTDrawNode;
import ch.randelshofer.tree.hypertree.HTModel;
import ch.randelshofer.tree.hypertree.HTView;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class SwingHTView
extends JPanel
implements HTView,
TreeView {
    private HTModel model = null;
    private HTDraw draw = null;
    private HTAction action = null;
    private boolean fastMode = false;
    private boolean longNameMode = false;
    private boolean circleMode = false;
    private boolean transNotCorrected = false;
    private boolean quadMode = true;
    private boolean isToolTipVisible = false;
    private Image image = null;
    private BufferedImage lazyBufferedImage;
    private boolean isThreaded = true;

    public SwingHTView(HTModel model) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 250));
        this.setBackground(Color.white);
        this.model = model;
        this.draw = new HTDraw(model, this);
        this.action = new HTAction(this.draw);
        this.startMouseListening();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public TreeNode getNodeUnderTheMouse(MouseEvent event) {
        int y;
        int x = event.getX();
        HTDrawNode node = this.draw.findNode(new HTCoordS(x, y = event.getY()));
        if (node != null) {
            return node.getHTModelNode().getNode();
        }
        return null;
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        HTDrawNode node = this.draw.findNode(new HTCoordS(x, y = event.getY()));
        if (node != null) {
            return this.model.getInfo().getTooltip(node.getHTModelNode().getDataNodePath());
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        if (g instanceof Graphics2D) {
            if (this.draw.isAdjusting() || this.draw.isAnimating()) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        long start1 = System.currentTimeMillis();
        this.draw.refreshScreenCoordinates();
        long start2 = System.currentTimeMillis();
        if (!this.isThreaded) {
            this.draw.drawBranches(g);
            this.draw.drawNodes(g);
        } else {
            if (this.lazyBufferedImage == null || this.lazyBufferedImage.getWidth() != this.getWidth() || this.lazyBufferedImage.getHeight() != this.getHeight()) {
                if (this.lazyBufferedImage != null) {
                    this.lazyBufferedImage.flush();
                    this.lazyBufferedImage = null;
                }
                this.lazyBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            }
            final BufferedImage i2 = this.lazyBufferedImage;
            Runnable r2 = new Runnable(){

                public void run() {
                    Graphics2D g2 = i2.createGraphics();
                    g2.setFont(SwingHTView.this.getFont());
                    if (SwingHTView.this.draw.isAdjusting() || SwingHTView.this.draw.isAnimating()) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    } else {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    g2.setComposite(AlphaComposite.getInstance(2));
                    g2.setBackground(new Color(0, true));
                    g2.clearRect(0, 0, i2.getWidth(), i2.getHeight());
                    g2.setComposite(AlphaComposite.getInstance(3));
                    SwingHTView.this.draw.drawNodes(g2);
                    g2.dispose();
                }
            };
            Thread t2 = new Thread(r2);
            t2.start();
            this.draw.drawBranches(g);
            try {
                t2.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            g.drawImage(i2, 0, 0, null);
        }
        long end = System.currentTimeMillis();
        g.setColor(Color.black);
    }

    public void stopMouseListening() {
        this.removeMouseListener(this.action);
        this.removeMouseMotionListener(this.action);
    }

    public void startMouseListening() {
        this.addMouseListener(this.action);
        this.addMouseMotionListener(this.action);
    }

    public void translateToOrigin(TreeNode node) {
        HTDrawNode drawNode = this.draw.findDrawNode(node);
        this.draw.translateToOrigin(drawNode);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setMaxDepth(int newValue) {
    }

    public int getMaxDepth() {
        return Integer.MAX_VALUE;
    }
}

