/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDrawNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

public class HTNodeLabel {
    private HTDrawNode node = null;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private boolean active = false;

    HTNodeLabel(HTDrawNode node) {
        this.node = node;
    }

    void draw(Graphics g, NodeInfo info) {
        FontMetrics fm = g.getFontMetrics();
        int fh = fm.getHeight();
        int space = this.node.getSpace();
        boolean isLeaf = this.node.getHTModelNode().isLeaf();
        if (space >= fh) {
            this.active = true;
            HTCoordS zs = this.node.getScreenCoordinates();
            String name = info.getName(this.node.getHTModelNode().getDataNodePath());
            Color color = info.getColor(this.node.getHTModelNode().getDataNodePath());
            Image icon = info.getImage(this.node.getHTModelNode().getDataNodePath());
            char[] nameC = name == null ? new char[]{} : name.toCharArray();
            int nameLength = nameC.length;
            int nameWidth = fm.charsWidth(nameC, 0, nameLength);
            while (nameWidth >= space && nameLength > 0) {
                nameC[--nameLength - 1] = 183;
                nameWidth = fm.charsWidth(nameC, 0, nameLength);
            }
            double weight = 0.0;
            this.height = fh + (int)(10.0 * weight);
            this.width = nameWidth + 10 + (int)(10.0 * weight);
            this.x = zs.x - this.width / 2 - (int)(5.0 * weight);
            this.y = zs.y - fh / 2 - (int)(5.0 * weight);
            g.setColor(color);
            if (isLeaf) {
                g.fillRect(this.x, this.y, this.width, this.height);
            } else {
                g.fillRoundRect(this.x, this.y, this.width, this.height, this.height, this.height);
            }
            if (icon != null) {
                g.drawImage(icon, this.x, this.y, null);
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            }
            int sx = zs.x - nameWidth / 2 - (int)(5.0 * weight);
            int sy = this.y + fm.getAscent() + fm.getLeading() / 2 + (int)(5.0 * weight);
            g.setColor(Color.BLACK);
            g.drawString(new String(nameC, 0, nameLength), sx, sy);
        } else {
            this.active = false;
            HTCoordS zs = this.node.getScreenCoordinates();
            Color color = info.getColor(this.node.getHTModelNode().getDataNodePath());
            double weight = 0.0;
            this.width = this.height = (this.width = Math.max(4, (int)(10.0 * weight)));
            this.x = zs.x - this.width / 2;
            this.y = zs.y - this.height / 2;
            g.setColor(color);
            if (isLeaf) {
                g.fillRect(this.x, this.y, this.width, this.height);
            } else {
                g.fillOval(this.x, this.y, this.width, this.height);
            }
        }
    }

    boolean contains(HTCoordS zs) {
        if (this.active) {
            return zs.x >= this.x && zs.x <= this.x + this.width && zs.y >= this.y && zs.y <= this.y + this.height;
        }
        return this.node.getScreenCoordinates().contains(zs);
    }

    public String toString() {
        String result = "label of " + this.node.toString() + "\n\tx = " + this.x + " : y = " + this.y + "\n\tw = " + this.width + " : h = " + this.height;
        return result;
    }
}

