/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTModel;
import ch.randelshofer.tree.hypertree.HTModelNode;
import java.util.ArrayList;
import java.util.Iterator;

public class HTModelNodeComposite
extends HTModelNode {
    private ArrayList children = new ArrayList();
    private double globalWeight = 0.0;

    HTModelNodeComposite(TreeNode node, HTModel model) {
        this(node, null, model);
    }

    HTModelNodeComposite(TreeNode node, HTModelNodeComposite parent, HTModel model) {
        super(node, parent, model);
        for (TreeNode childNode : node.children()) {
            HTModelNode child = !childNode.getAllowsChildren() ? new HTModelNode(childNode, this, model) : new HTModelNodeComposite(childNode, this, model);
            this.addChild(child);
        }
        this.computeWeight();
    }

    private void computeWeight() {
        HTModelNode child = null;
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTModelNode)i.next();
            this.globalWeight += child.getWeight();
        }
        if (this.globalWeight != 0.0) {
            this.weight += Math.log(this.globalWeight);
        }
    }

    Iterator children() {
        return this.children.iterator();
    }

    void addChild(HTModelNode child) {
        this.children.add(child);
    }

    boolean isLeaf() {
        return false;
    }

    void layout(double angle, double width, double length) {
        super.layout(angle, width, length);
        if (this.parent != null) {
            HTCoordE a = new HTCoordE(Math.cos(angle), Math.sin(angle));
            HTCoordE nz = new HTCoordE(-this.z.x, -this.z.y);
            a.translate(this.parent.getCoordinates());
            a.translate(nz);
            angle = a.arg();
            double c = Math.cos(width);
            double A = 1.0 + length * length;
            double B = 2.0 * length;
            width = Math.acos((A * c - B) / (A - B * c));
        }
        HTModelNode child = null;
        HTCoordE dump = new HTCoordE();
        int nbrChild = this.children.size();
        double l1 = 0.95 - this.model.getLength();
        double l2 = Math.cos(62.83185307179586 / (2.0 * (double)nbrChild + 38.0));
        length = this.model.getLength() + l1 * l2;
        double startAngle = angle - width;
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTModelNode)i.next();
            double percent = child.getWeight() / this.globalWeight;
            double childWidth = width * percent;
            double childAngle = startAngle + childWidth;
            child.layout(childAngle, childWidth, length);
            startAngle += 2.0 * childWidth;
        }
    }

    public String toString() {
        String result = super.toString();
        HTModelNode child = null;
        result = result + "\n\tChildren :";
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTModelNode)i.next();
            result = result + "\n\t-> " + child.getName();
        }
        return result;
    }
}

