/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTModel;
import ch.randelshofer.tree.hypertree.HTModelNodeComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTModelNode {
    protected HTModel model = null;
    protected HTModelNodeComposite parent = null;
    protected HTCoordE z = null;
    protected double weight = 1.0;
    private TreePath2<TreeNode> dataNodePath;

    HTModelNode(TreeNode node, HTModel model) {
        this(node, null, model);
    }

    HTModelNode(TreeNode data, HTModelNodeComposite parent, HTModel model) {
        this.dataNodePath = parent == null ? new TreePath2(data) : parent.getDataNodePath().pathByAddingChild(data);
        this.parent = parent;
        this.model = model;
        model.incrementNumberOfNodes();
        this.z = new HTCoordE();
    }

    TreeNode getNode() {
        return this.dataNodePath.getLastPathComponent();
    }

    public TreePath2<TreeNode> getDataNodePath() {
        return this.dataNodePath;
    }

    String getName() {
        return this.model.getInfo().getName(this.getDataNodePath());
    }

    double getWeight() {
        return this.weight;
    }

    HTModelNodeComposite getParent() {
        return this.parent;
    }

    boolean isLeaf() {
        return true;
    }

    HTCoordE getCoordinates() {
        return this.z;
    }

    void layoutHyperbolicTree() {
        this.layout(0.0, Math.PI, this.model.getLength());
    }

    void layout(double angle, double width, double length) {
        if (this.parent == null) {
            return;
        }
        HTCoordE zp = this.parent.getCoordinates();
        this.z.x = length * Math.cos(angle);
        this.z.y = length * Math.sin(angle);
        this.z.translate(zp);
    }

    public String toString() {
        String result = this.getName() + "\n\t" + this.z + "\n\tWeight = " + this.weight;
        return result;
    }
}

