/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTCoordS;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.QuadCurve2D;

class HTGeodesic {
    private static final double EPSILON = 1.0E-10;
    private static final int LINE = 0;
    private static final int ARC = 1;
    private int type = 0;
    private HTCoordE za = null;
    private HTCoordE zb = null;
    private HTCoordE zc = null;
    private HTCoordE zo = null;
    private HTCoordS a = null;
    private HTCoordS b = null;
    private HTCoordS c = null;

    HTGeodesic(HTCoordE za, HTCoordE zb) {
        this.za = za;
        this.zb = zb;
        this.zc = new HTCoordE();
        this.zo = new HTCoordE();
        this.a = new HTCoordS();
        this.b = new HTCoordS();
        this.c = new HTCoordS();
        this.rebuild();
    }

    void refreshScreenCoordinates(HTCoordS sOrigin, HTCoordS sMax) {
        this.a.projectionEtoS(this.za, sOrigin, sMax);
        this.b.projectionEtoS(this.zb, sOrigin, sMax);
        this.c.projectionEtoS(this.zc, sOrigin, sMax);
    }

    void rebuild() {
        if (Math.abs(this.za.d()) < 1.0E-10 || Math.abs(this.zb.d()) < 1.0E-10 || Math.abs(this.za.x / this.zb.x - this.za.y / this.zb.y) < 1.0E-10) {
            this.type = 0;
        } else {
            this.type = 1;
            double da = 1.0 + this.za.x * this.za.x + this.za.y * this.za.y;
            double db = 1.0 + this.zb.x * this.zb.x + this.zb.y * this.zb.y;
            double dd = 2.0 * (this.za.x * this.zb.y - this.zb.x * this.za.y);
            this.zo.x = (this.zb.y * da - this.za.y * db) / dd;
            this.zo.y = (this.za.x * db - this.zb.x * da) / dd;
            double det = (this.zb.x - this.zo.x) * (this.za.y - this.zo.y) - (this.za.x - this.zo.x) * (this.zb.y - this.zo.y);
            double fa = this.za.y * (this.za.y - this.zo.y) - this.za.x * (this.zo.x - this.za.x);
            double fb = this.zb.y * (this.zb.y - this.zo.y) - this.zb.x * (this.zo.x - this.zb.x);
            this.zc.x = ((this.za.y - this.zo.y) * fb - (this.zb.y - this.zo.y) * fa) / det;
            this.zc.y = ((this.zo.x - this.za.x) * fb - (this.zo.x - this.zb.x) * fa) / det;
        }
    }

    void draw(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            switch (this.type) {
                case 0: {
                    g2.drawLine(this.a.x, this.a.y, this.b.x, this.b.y);
                    break;
                }
                case 1: {
                    g2.draw(new QuadCurve2D.Double(this.a.x, this.a.y, this.c.x, this.c.y, this.b.x, this.b.y));
                    break;
                }
            }
        } else {
            System.err.println("only Graphics available");
            g.drawLine(this.a.x, this.a.y, this.b.x, this.b.y);
        }
    }

    public String toString() {
        String result = "Geodesic betweens : \n\t A: " + this.za + "\n\t B: " + this.zb + "\n\t is ";
        switch (this.type) {
            case 0: {
                result = result + "a line.";
                break;
            }
            case 1: {
                result = result + "an arc.";
                break;
            }
            default: {
                result = result + "nothing ?";
            }
        }
        return result;
    }
}

