/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDraw;
import ch.randelshofer.tree.hypertree.HTDrawNode;
import ch.randelshofer.tree.hypertree.HTGeodesic;
import ch.randelshofer.tree.hypertree.HTModelNode;
import ch.randelshofer.tree.hypertree.HTModelNodeComposite;
import ch.randelshofer.tree.hypertree.HTTransformation;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HTDrawNodeComposite
extends HTDrawNode {
    private HTModelNodeComposite node = null;
    private ArrayList children = null;
    private HashMap geodesics = null;

    HTDrawNodeComposite(HTDrawNodeComposite father, HTModelNodeComposite node, HTDraw model) {
        super(father, node, model);
        this.node = node;
        this.children = new ArrayList();
        this.geodesics = new HashMap();
        HTModelNode childNode = null;
        HTDrawNode child = null;
        HTDrawNode brother = null;
        boolean first = true;
        boolean second = false;
        Iterator i = node.children();
        while (i.hasNext()) {
            childNode = (HTModelNode)i.next();
            child = childNode.isLeaf() ? new HTDrawNode(this, childNode, model) : new HTDrawNodeComposite(this, (HTModelNodeComposite)childNode, model);
            this.addChild(child);
            if (first) {
                brother = child;
                first = false;
                second = true;
                continue;
            }
            if (second) {
                child.setBrother(brother);
                brother.setBrother(child);
                brother = child;
                second = false;
                continue;
            }
            child.setBrother(brother);
            brother = child;
        }
    }

    Iterator children() {
        return this.children.iterator();
    }

    void addChild(HTDrawNode child) {
        this.children.add(child);
        this.geodesics.put(child, new HTGeodesic(this.getCoordinates(), child.getCoordinates()));
    }

    void refreshScreenCoordinates(HTCoordS sOrigin, HTCoordS sMax) {
        super.refreshScreenCoordinates(sOrigin, sMax);
        HTDrawNode child = null;
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTDrawNode)i.next();
            child.refreshScreenCoordinates(sOrigin, sMax);
            HTGeodesic geod = (HTGeodesic)this.geodesics.get(child);
            if (geod == null) continue;
            geod.refreshScreenCoordinates(sOrigin, sMax);
        }
    }

    void drawBranches(Graphics g, NodeInfo info) {
        HTDrawNode child = null;
        Iterator i = this.children();
        while (i.hasNext()) {
            HTGeodesic geod;
            child = (HTDrawNode)i.next();
            if (child.getFatherSpace() > 1 && (geod = (HTGeodesic)this.geodesics.get(child)) != null) {
                g.setColor(info.getColor(child.getHTModelNode().getDataNodePath()).darker());
                geod.draw(g);
            }
            if (this.fastMode) continue;
            child.drawBranches(g, info);
        }
    }

    void drawNodes(Graphics g, NodeInfo info) {
        if (!this.fastMode) {
            super.drawNodes(g, info);
            HTDrawNode child = null;
            Iterator i = this.children();
            while (i.hasNext()) {
                child = (HTDrawNode)i.next();
                child.drawNodes(g, info);
            }
        }
    }

    int getSpace() {
        int space = super.getSpace();
        if (!this.children.isEmpty()) {
            HTDrawNode child = (HTDrawNode)this.children.get(0);
            HTCoordS zC = child.getScreenCoordinates();
            int dC = this.zs.getDistance(zC);
            if (space == -1) {
                return dC;
            }
            return Math.min(space, dC);
        }
        return space;
    }

    void translate(HTCoordE t) {
        super.translate(t);
        if (!this.fastMode) {
            HTDrawNode child = null;
            Iterator i = this.children();
            while (i.hasNext()) {
                child = (HTDrawNode)i.next();
                child.translate(t);
                HTGeodesic geod = (HTGeodesic)this.geodesics.get(child);
                if (geod == null) continue;
                geod.rebuild();
            }
        }
    }

    void transform(HTTransformation t) {
        super.transform(t);
        if (!this.fastMode) {
            HTDrawNode child = null;
            Iterator i = this.children();
            while (i.hasNext()) {
                child = (HTDrawNode)i.next();
                child.transform(t);
                HTGeodesic geod = (HTGeodesic)this.geodesics.get(child);
                if (geod == null) continue;
                geod.rebuild();
            }
        }
    }

    void endTranslation() {
        super.endTranslation();
        if (!this.fastMode) {
            HTDrawNode child = null;
            Iterator i = this.children();
            while (i.hasNext()) {
                child = (HTDrawNode)i.next();
                child.endTranslation();
            }
        }
    }

    void restore() {
        super.restore();
        HTDrawNode child = null;
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTDrawNode)i.next();
            child.restore();
            HTGeodesic geod = (HTGeodesic)this.geodesics.get(child);
            if (geod == null) continue;
            geod.rebuild();
        }
    }

    void fastMode(boolean mode) {
        super.fastMode(mode);
        if (!mode) {
            HTDrawNode child = null;
            Iterator i = this.children();
            while (i.hasNext()) {
                child = (HTDrawNode)i.next();
                child.fastMode(mode);
            }
        }
    }

    HTDrawNode findNode(HTCoordS zs) {
        HTDrawNode result = super.findNode(zs);
        if (result != null) {
            return result;
        }
        HTDrawNode child = null;
        if (!this.fastMode) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                child = (HTDrawNode)this.children.get(i);
                result = child.findNode(zs);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public String toString() {
        String result = super.toString();
        HTDrawNode child = null;
        result = result + "\n\tChildren :";
        Iterator i = this.children();
        while (i.hasNext()) {
            child = (HTDrawNode)i.next();
            result = result + "\n\t-> " + child.toString();
        }
        return result;
    }
}

