/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDraw;
import ch.randelshofer.tree.hypertree.HTDrawNodeComposite;
import ch.randelshofer.tree.hypertree.HTModelNode;
import ch.randelshofer.tree.hypertree.HTNodeLabel;
import ch.randelshofer.tree.hypertree.HTTransformation;
import java.awt.Graphics;

class HTDrawNode {
    private HTDraw model = null;
    private HTModelNode node = null;
    private HTCoordE ze = null;
    private HTCoordE oldZe = null;
    protected HTCoordS zs = null;
    private HTDrawNodeComposite father = null;
    private HTDrawNode brother = null;
    private HTNodeLabel label = null;
    protected boolean fastMode = false;

    HTDrawNode(HTDrawNodeComposite father, HTModelNode node, HTDraw model) {
        this.father = father;
        this.node = node;
        this.model = model;
        this.label = new HTNodeLabel(this);
        this.ze = new HTCoordE(node.getCoordinates());
        this.oldZe = new HTCoordE(this.ze);
        this.zs = new HTCoordS();
        model.mapNode(node.getNode(), this);
    }

    void setBrother(HTDrawNode brother) {
        this.brother = brother;
    }

    HTModelNode getHTModelNode() {
        return this.node;
    }

    HTCoordE getCoordinates() {
        return this.ze;
    }

    HTCoordE getOldCoordinates() {
        return this.oldZe;
    }

    HTCoordS getScreenCoordinates() {
        return this.zs;
    }

    void refreshScreenCoordinates(HTCoordS sOrigin, HTCoordS sMax) {
        this.zs.projectionEtoS(this.ze, sOrigin, sMax);
    }

    void drawBranches(Graphics g, NodeInfo info) {
    }

    void drawNodes(Graphics g, NodeInfo info) {
        if (this.getSpace() > 1 && !this.fastMode) {
            this.label.draw(g, info);
        }
    }

    int getSpace() {
        int dF = -1;
        int dB = -1;
        if (this.father != null) {
            HTCoordS zF = this.father.getScreenCoordinates();
            dF = this.zs.getDistance(zF);
        }
        if (this.brother != null) {
            HTCoordS zB = this.brother.getScreenCoordinates();
            dB = this.zs.getDistance(zB);
        }
        if (dF == -1 && dB == -1) {
            return Integer.MAX_VALUE;
        }
        if (dF == -1) {
            return dB;
        }
        if (dB == -1) {
            return dF;
        }
        return Math.min(dF, dB);
    }

    int getFatherSpace() {
        int dF = -1;
        if (this.father != null) {
            HTCoordS zF = this.father.getScreenCoordinates();
            dF = this.zs.getDistance(zF);
        }
        if (dF == -1) {
            return Integer.MAX_VALUE;
        }
        return dF;
    }

    void translate(HTCoordE t) {
        this.ze.translate(this.oldZe, t);
    }

    void transform(HTTransformation t) {
        this.ze.copy(this.oldZe);
        this.ze.transform(t);
    }

    void endTranslation() {
        this.oldZe.copy(this.ze);
    }

    void restore() {
        HTCoordE orig = this.node.getCoordinates();
        this.ze.x = orig.x;
        this.ze.y = orig.y;
        this.oldZe.copy(this.ze);
    }

    void fastMode(boolean mode) {
        if (mode != this.fastMode) {
            this.fastMode = mode;
        }
    }

    HTDrawNode findNode(HTCoordS zs) {
        if (!this.fastMode && this.label.contains(zs)) {
            return this;
        }
        return null;
    }

    public String toString() {
        String result = this.node.getName() + "\n\t" + this.ze + "\n\t" + this.zs;
        return result;
    }
}

