/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDrawNode;
import ch.randelshofer.tree.hypertree.HTDrawNodeComposite;
import ch.randelshofer.tree.hypertree.HTModel;
import ch.randelshofer.tree.hypertree.HTModelNode;
import ch.randelshofer.tree.hypertree.HTModelNodeComposite;
import ch.randelshofer.tree.hypertree.HTTransformation;
import ch.randelshofer.tree.hypertree.HTView;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class HTDraw {
    private static final int NBR_FRAMES = 10;
    private HTModel model = null;
    private HTView view = null;
    private HTDrawNode drawRoot = null;
    private HTCoordS sOrigin = null;
    private HTCoordS sMax = null;
    private double[] ray = null;
    private boolean fastMode = false;
    private Map drawToHTNodeMap = new HashMap();
    public boolean isAnimationEnabled = true;
    private boolean isAdjusting;
    private volatile boolean isAnimating;
    private NodeInfo info;

    HTDraw(HTModel model, HTView view) {
        this.view = view;
        this.model = model;
        HTModelNode root = model.getRoot();
        this.sOrigin = new HTCoordS();
        this.sMax = new HTCoordS();
        this.ray = new double[4];
        this.ray[0] = model.getLength();
        for (int i = 1; i < this.ray.length; ++i) {
            this.ray[i] = (this.ray[0] + this.ray[i - 1]) / (1.0 + this.ray[0] * this.ray[i - 1]);
        }
        this.drawRoot = root.isLeaf() ? new HTDrawNode(null, root, this) : new HTDrawNodeComposite(null, (HTModelNodeComposite)root, this);
        this.info = model.getInfo();
    }

    void refreshScreenCoordinates() {
        Insets insets = this.view.getInsets();
        this.sMax.x = (this.view.getWidth() - insets.left - insets.right) / 2;
        this.sMax.y = (this.view.getHeight() - insets.top - insets.bottom) / 2;
        this.sOrigin.x = this.sMax.x + insets.left;
        this.sOrigin.y = this.sMax.y + insets.top;
        this.drawRoot.refreshScreenCoordinates(this.sOrigin, this.sMax);
    }

    HTCoordS getSOrigin() {
        return this.sOrigin;
    }

    HTCoordS getSMax() {
        return this.sMax;
    }

    void drawBranches(Graphics g) {
        this.drawRoot.drawBranches(g, this.info);
    }

    void drawNodes(Graphics g) {
        this.drawRoot.drawNodes(g, this.info);
    }

    void translate(HTCoordE zs, HTCoordE ze) {
        HTCoordE zo = new HTCoordE(this.drawRoot.getOldCoordinates());
        zo.x = -zo.x;
        zo.y = -zo.y;
        HTCoordE zs2 = new HTCoordE(zs);
        zs2.translate(zo);
        HTCoordE t = new HTCoordE();
        double de = ze.d2();
        double ds = zs2.d2();
        double dd = 1.0 - de * ds;
        t.x = (ze.x * (1.0 - ds) - zs2.x * (1.0 - de)) / dd;
        t.y = (ze.y * (1.0 - ds) - zs2.y * (1.0 - de)) / dd;
        if (t.isValid()) {
            HTTransformation to = new HTTransformation();
            to.composition(zo, t);
            this.drawRoot.transform(to);
            this.view.repaint();
        }
    }

    void endTranslation() {
        this.drawRoot.endTranslation();
    }

    void translateToOrigin(HTDrawNode node) {
        this.view.stopMouseListening();
        AnimThread t = new AnimThread(node);
        t.start();
    }

    void restore() {
        this.drawRoot.restore();
        this.view.repaint();
    }

    void fastMode(boolean mode) {
        if (mode != this.fastMode) {
            this.fastMode = mode;
            this.drawRoot.fastMode(mode);
            if (!mode) {
                this.view.repaint();
            }
        }
    }

    public void repaint() {
        this.view.repaint();
    }

    public void setAdjusting(boolean newValue) {
        this.isAdjusting = newValue;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    HTDrawNode findNode(HTCoordS zs) {
        return this.drawRoot.findNode(zs);
    }

    protected void mapNode(TreeNode htNode, HTDrawNode drawNode) {
        this.drawToHTNodeMap.put(htNode, drawNode);
    }

    protected HTDrawNode findDrawNode(TreeNode htNode) {
        HTDrawNode drawNode = (HTDrawNode)this.drawToHTNodeMap.get(htNode);
        return drawNode;
    }

    class AnimThread
    extends Thread {
        private HTDrawNode node = null;
        private Runnable tTask = null;

        AnimThread(HTDrawNode node) {
            this.node = node;
        }

        public void run() {
            HTCoordE zn = this.node.getOldCoordinates();
            HTCoordE zf = new HTCoordE();
            int frames = 10;
            int nodes = HTDraw.this.model.getNumberOfNodes();
            double d = zn.d();
            for (int i = 0; i < HTDraw.this.ray.length; ++i) {
                if (!(d > HTDraw.this.ray[i])) continue;
                frames += 5;
            }
            if (HTDraw.this.isAnimationEnabled) {
                HTDraw.this.isAnimating = true;
                long delay = 10L;
                long elapse = 1000L;
                double factorX = zn.x / (double)elapse;
                double factorY = zn.y / (double)elapse;
                long start = System.currentTimeMillis() - delay;
                long end = start + elapse;
                long now = start;
                while (now < end) {
                    long i = now - start;
                    zf.x = zn.x - (double)i * factorX;
                    zf.y = zn.y - (double)i * factorY;
                    this.tTask = new TranslateThread(zn, zf);
                    try {
                        SwingUtilities.invokeAndWait(this.tTask);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    long next = System.currentTimeMillis();
                    if (next < now + delay) {
                        try {
                            Thread.sleep(now + delay - next);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                    now = next;
                }
            }
            zf.x = 0.0;
            zf.y = 0.0;
            this.tTask = new LastTranslateThread(zn, zf);
            try {
                SwingUtilities.invokeAndWait(this.tTask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HTDraw.this.isAnimating = false;
        }

        class LastTranslateThread
        implements Runnable {
            HTCoordE zStart = null;
            HTCoordE zEnd = null;

            LastTranslateThread(HTCoordE z1, HTCoordE z2) {
                this.zStart = z1;
                this.zEnd = z2;
            }

            public void run() {
                HTDraw.this.translate(this.zStart, this.zEnd);
                HTDraw.this.endTranslation();
                HTDraw.this.view.repaint();
                HTDraw.this.view.startMouseListening();
            }
        }

        class TranslateThread
        implements Runnable {
            HTCoordE zStart = null;
            HTCoordE zEnd = null;

            TranslateThread(HTCoordE z1, HTCoordE z2) {
                this.zStart = z1;
                this.zEnd = z2;
            }

            public void run() {
                HTDraw.this.translate(this.zStart, this.zEnd);
                HTDraw.this.view.repaint();
            }
        }
    }
}

