/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTTransformation;

class HTCoordE {
    private static final double EPSILON = 1.0E-10;
    double x = 0.0;
    double y = 0.0;

    HTCoordE() {
    }

    HTCoordE(HTCoordE z) {
        this.copy(z);
    }

    HTCoordE(double x, double y) {
        this.x = x;
        this.y = y;
    }

    void copy(HTCoordE z) {
        this.x = z.x;
        this.y = z.y;
    }

    void projectionStoE(int x, int y, HTCoordS sOrigin, HTCoordS sMax) {
        this.x = (double)(x - sOrigin.x) / (double)sMax.x;
        this.y = -((double)(y - sOrigin.y) / (double)sMax.y);
    }

    boolean isValid() {
        return this.d2() < 1.0;
    }

    void multiply(HTCoordE z) {
        double tx = this.x;
        double ty = this.y;
        this.x = tx * z.x - ty * z.y;
        this.y = tx * z.y + ty * z.x;
    }

    void divide(HTCoordE z) {
        double d = z.d2();
        double tx = this.x;
        double ty = this.y;
        this.x = (tx * z.x + ty * z.y) / d;
        this.y = (ty * z.x - tx * z.y) / d;
    }

    void sub(HTCoordE a, HTCoordE b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
    }

    double arg() {
        double a = Math.atan(this.y / this.x);
        if (this.x < 0.0) {
            a += Math.PI;
        } else if (this.y < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    double d2() {
        return this.x * this.x + this.y * this.y;
    }

    double d() {
        return Math.sqrt(this.d2());
    }

    double d(HTCoordE p) {
        return Math.sqrt((p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y));
    }

    void translate(HTCoordE t) {
        double denX = this.x * t.x + this.y * t.y + 1.0;
        double denY = this.y * t.x - this.x * t.y;
        double dd = denX * denX + denY * denY;
        double numX = this.x + t.x;
        double numY = this.y + t.y;
        this.x = (numX * denX + numY * denY) / dd;
        this.y = (numY * denX - numX * denY) / dd;
    }

    void translate(HTCoordE s, HTCoordE t) {
        this.copy(s);
        this.translate(t);
    }

    void transform(HTTransformation t) {
        HTCoordE z = new HTCoordE(this);
        this.multiply(t.O);
        this.x += t.P.x;
        this.y += t.P.y;
        HTCoordE d = new HTCoordE(t.P);
        d.y = -d.y;
        d.multiply(z);
        d.multiply(t.O);
        d.x += 1.0;
        this.divide(d);
    }

    public String toString() {
        return "(" + this.x + " : " + this.y + ")E";
    }
}

