/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.hypertree;

import ch.randelshofer.tree.hypertree.HTCoordE;
import ch.randelshofer.tree.hypertree.HTCoordS;
import ch.randelshofer.tree.hypertree.HTDraw;
import ch.randelshofer.tree.hypertree.HTDrawNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class HTAction
extends MouseAdapter
implements MouseMotionListener {
    private HTDraw model = null;
    private HTCoordE startPoint = null;
    private HTCoordE endPoint = null;
    private HTCoordS clickPoint = null;

    HTAction(HTDraw model) {
        this.model = model;
        this.startPoint = new HTCoordE();
        this.endPoint = new HTCoordE();
        this.clickPoint = new HTCoordS();
    }

    public void mousePressed(MouseEvent e) {
        if (e.isShiftDown()) {
            this.model.fastMode(true);
        }
        this.startPoint.projectionStoE(e.getX(), e.getY(), this.model.getSOrigin(), this.model.getSMax());
    }

    public void mouseReleased(MouseEvent e) {
        if (this.model.isAdjusting()) {
            this.model.setAdjusting(false);
            this.model.repaint();
        }
        this.model.fastMode(false);
        this.model.endTranslation();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isShiftDown()) {
            this.model.restore();
        } else {
            this.clickPoint.x = e.getX();
            this.clickPoint.y = e.getY();
            HTDrawNode node = this.model.findNode(this.clickPoint);
            if (node != null) {
                this.model.translateToOrigin(node);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.model.setAdjusting(true);
        if (this.startPoint.isValid()) {
            this.endPoint.projectionStoE(e.getX(), e.getY(), this.model.getSOrigin(), this.model.getSMax());
            if (this.endPoint.isValid()) {
                this.model.translate(this.startPoint, this.endPoint);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

