/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressView;
import ch.randelshofer.io.BoundedRangeInputStream;
import ch.randelshofer.io.SuspendableInputStream;
import ch.randelshofer.tree.demo.DemoTree;
import ch.randelshofer.tree.demo.XMLNode;
import ch.randelshofer.tree.demo.XMLNodeInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTree
implements DemoTree {
    private XMLNode root;
    private XMLNodeInfo info;
    private ProgressObserver p = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLTree(File xmlFile) throws IOException {
        if (this.p == null) {
            this.p = new ProgressView("Opening " + xmlFile.getName(), "", 0, 1);
            this.p.setIndeterminate(true);
        }
        try {
            this.root = new XMLNode();
            this.info = new XMLNodeInfo();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputStream in = null;
            try {
                BoundedRangeInputStream bris;
                SAXParser saxParser = factory.newSAXParser();
                if (xmlFile.getName().endsWith(".zip")) {
                    bris = null;
                    in = new FileInputStream(xmlFile);
                    ZipInputStream zis = new ZipInputStream(in);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith(".xml")) {
                            bris = new BoundedRangeInputStream(zis);
                            if (entry.getSize() == -1L) break;
                            bris.setMaximum((int)entry.getSize() + 1);
                            break;
                        }
                        entry = zis.getNextEntry();
                    }
                    if (bris == null) {
                        throw new IOException("No XML file found inside of " + xmlFile + ".");
                    }
                } else {
                    in = new FileInputStream(xmlFile);
                    bris = new BoundedRangeInputStream(in);
                    bris.setMaximum((int)xmlFile.length() + 1);
                }
                final SuspendableInputStream sis = new SuspendableInputStream(bris);
                this.p.setModel(bris);
                this.p.setIndeterminate(false);
                this.p.setDoCancel(new Runnable(){

                    public void run() {
                        sis.abort();
                    }
                });
                saxParser.parse((InputStream)sis, new DefaultHandler(){
                    private Stack<XMLNode> stack = new Stack();
                    {
                        this.stack.push(XMLTree.this.root);
                    }

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        XMLNode node = new XMLNode();
                        node.setName(qName.intern());
                        int n = attributes.getLength();
                        for (int i = 0; i < n; ++i) {
                            String name = attributes.getLocalName(i).intern();
                            node.putAttribute(name, attributes.getValue(i).intern());
                        }
                        this.stack.peek().addChild(node);
                        this.stack.push(node);
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        this.stack.pop();
                    }
                });
            }
            catch (ParserConfigurationException ex) {
                IOException iex = new IOException("XML Parser configuration error");
                iex.initCause(ex);
                throw iex;
            }
            catch (SAXException ex) {
                IOException iex = new IOException("XML Error");
                iex.initCause(ex);
                throw iex;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.p.setNote("Calculating statistics");
            this.p.setIndeterminate(true);
            this.info.init(this.root);
        }
        finally {
            this.p.close();
        }
    }

    public XMLNode getRoot() {
        return this.root;
    }

    public XMLNodeInfo getInfo() {
        return this.info;
    }
}

