/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.AbstractNodeInfo;
import ch.randelshofer.tree.demo.RGBColorizer;
import ch.randelshofer.tree.demo.XMLInfoWeighter;
import ch.randelshofer.tree.demo.XMLNode;
import ch.randelshofer.util.FileSizeFormat;
import java.awt.Color;
import java.awt.Image;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNodeInfo
extends AbstractNodeInfo {
    private FileSizeFormat shortWeightFormat;
    private FileSizeFormat longWeightFormat;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent;
    private Colorizer colorizer = new RGBColorizer();
    private Weighter colorWeighter;
    private Weighter weighter;
    private boolean isInitialized;
    private HashMap<String, HashSet<String>> attributes = new HashMap();
    private HashMap<String, AbstractNodeInfo.DataType> types;
    private String nameAttribute;
    private String weightAttribute;
    private String colorAttribute;

    public XMLNodeInfo() {
        this.shortWeightFormat = new FileSizeFormat();
        this.shortWeightFormat.setShortFormat(true);
        this.shortWeightFormat.setMaximumFractionDigits(0);
        this.longWeightFormat = new FileSizeFormat();
        this.longWeightFormat.setMaximumFractionDigits(1);
        this.longWeightFormat.setAlwaysIncludeBytes(true);
    }

    @Override
    public void init(TreeNode root) {
        this.init((XMLNode)root);
    }

    @Override
    public String getName(TreePath2<TreeNode> path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        if (this.nameAttribute != null && node.getAttribute(this.nameAttribute) != null) {
            return node.getAttribute(this.nameAttribute);
        }
        return node.getName();
    }

    @Override
    public Color getColor(TreePath2<TreeNode> path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        return this.colorizer == null || this.colorWeighter == null ? Color.WHITE : this.colorizer.get(this.colorWeighter.getWeight(path));
    }

    @Override
    public long getWeight(TreePath2<TreeNode> path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        if (this.weightAttribute != null && node.getAttribute(this.weightAttribute) != null) {
            return Math.max(1L, Long.valueOf(node.getAttribute(this.weightAttribute)));
        }
        return 1L;
    }

    @Override
    public String getTooltip(TreePath2<TreeNode> path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        StringBuilder buf = new StringBuilder();
        TreePath2 parentPath = path;
        do {
            buf.insert(0, "<br>");
            buf.insert(0, this.getName(parentPath));
        } while ((parentPath = parentPath.getParentPath()) != null && parentPath.getPathCount() > 1);
        buf.insert(0, "<html>");
        buf.append("<br>");
        buf.append(this.formatSize(this.getWeight(path)));
        buf.append("<br>type: ");
        buf.append(node.getName());
        if (node.getAllowsChildren()) {
            buf.append("<br>children: ");
            buf.append(DecimalFormat.getIntegerInstance().format(node.children().size()));
        }
        HashMap<String, String> attr = node.getAttributes();
        for (Map.Entry entry : attr.entrySet()) {
            buf.append("<br>" + (String)entry.getKey() + ": ");
            if (((String)entry.getKey()).toLowerCase().endsWith("size") && this.types.get(entry.getKey()) == AbstractNodeInfo.DataType.NUMERIC_STRING) {
                buf.append(this.formatSize(Long.valueOf((String)entry.getValue())));
                continue;
            }
            buf.append((String)entry.getValue());
        }
        return buf.toString();
    }

    private String formatSize(long w) {
        return this.longWeightFormat.format(w);
    }

    @Override
    public Image getImage(TreePath2<TreeNode> path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        return null;
    }

    @Override
    public Weighter getWeighter() {
        return this.colorWeighter;
    }

    @Override
    public Colorizer getColorizer() {
        return this.colorizer;
    }

    public void init(XMLNode root) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.types = new HashMap();
            this.attributes = new HashMap();
            this.computeStats(root, this.types, this.attributes);
        }
    }

    public void computeStats(XMLNode root, HashMap<String, AbstractNodeInfo.DataType> typeMap, HashMap<String, HashSet<String>> attrMap) {
        this.collectAttributesRecursively(root, attrMap);
        for (Map.Entry<String, HashSet<String>> entry : attrMap.entrySet()) {
            typeMap.put(entry.getKey(), this.determineDataType((Set<String>)entry.getValue()));
        }
        this.nameAttribute = null;
        if (typeMap.get("name") != null) {
            this.nameAttribute = "name";
        } else {
            for (Map.Entry<String, Object> entry : typeMap.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.TEXT_STRING || this.nameAttribute != null && this.nameAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.nameAttribute = entry.getKey();
            }
        }
        this.weightAttribute = null;
        if (typeMap.get("size") == AbstractNodeInfo.DataType.NUMERIC_STRING) {
            this.weightAttribute = "size";
        } else {
            for (Map.Entry<String, Object> entry : typeMap.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.NUMERIC_STRING || this.weightAttribute != null && this.weightAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.weightAttribute = entry.getKey();
            }
        }
        this.weighter = new XMLInfoWeighter(this, this.weightAttribute);
        root.accumulateWeights(this, null);
        this.colorAttribute = null;
        if (typeMap.get("created") == AbstractNodeInfo.DataType.DATE_STRING) {
            this.colorAttribute = "created";
        } else {
            for (Map.Entry<String, Object> entry : typeMap.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.DATE_STRING || this.colorAttribute != null && this.colorAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.colorAttribute = entry.getKey();
            }
        }
        if (this.colorAttribute == null) {
            this.weighter = null;
        } else {
            this.colorWeighter = new XMLInfoWeighter(this, this.colorAttribute);
            this.colorWeighter.init(root);
        }
        this.colorizer = new RGBColorizer(new float[]{0.0f, ((XMLInfoWeighter)this.colorWeighter).getMedianWeight(), 1.0f}, new Color[]{new Color(6605055), new Color(0xF5F5F5), new Color(16750918)});
    }

    public void collectAttributesRecursively(XMLNode node, HashMap<String, HashSet<String>> attrMap) {
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            HashSet<Object> valueSet;
            String key = entry.getKey();
            String value = entry.getValue();
            if (attrMap.containsKey(key)) {
                valueSet = attrMap.get(key);
            } else {
                valueSet = new HashSet();
                attrMap.put(key, valueSet);
            }
            valueSet.add(value);
        }
        for (TreeNode child : node.children()) {
            this.collectAttributesRecursively((XMLNode)child, attrMap);
        }
    }

    public AbstractNodeInfo.DataType getType(String key) {
        return this.types.get(key);
    }

    public Set<String> getValues(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return DecimalFormat.getIntegerInstance().format(this.getWeight(path));
    }
}

