/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.AbstractNodeInfo;
import ch.randelshofer.tree.demo.XMLNode;
import ch.randelshofer.tree.demo.XMLNodeInfo;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInfoWeighter
implements Weighter {
    private XMLNodeInfo info;
    private String key;
    private int[] histogram;
    private Object min;
    private Object max;
    private Object median;
    private static DateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static DateFormat isoDateFormatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public XMLInfoWeighter(XMLNodeInfo info, String key) {
        this.info = info;
        this.key = key;
    }

    @Override
    public void init(TreeNode root) {
        if (this.info.getType(this.key) == AbstractNodeInfo.DataType.DATE_STRING) {
            Date minDate = new Date(Long.MAX_VALUE);
            Date maxDate = new Date(Long.MIN_VALUE);
            Set<String> stringValues = this.info.getValues(this.key);
            ArrayList<Date> dates = new ArrayList<Date>();
            this.collectDatesRecursive((XMLNode)root, dates);
            Collections.sort(dates);
            if (dates.size() > 0) {
                minDate = dates.get(0);
                maxDate = dates.get(dates.size() - 1);
                this.median = dates.get(dates.size() / 2);
                this.min = minDate;
                this.max = maxDate;
            }
            if (!maxDate.equals(minDate)) {
                this.histogram = new int[256];
                this.calculateDateHistogramRecursive(root);
            } else {
                this.histogram = new int[1];
                this.histogram[0] = 1;
            }
        } else {
            this.histogram = new int[1];
            this.histogram[0] = 1;
        }
    }

    private void collectDatesRecursive(XMLNode node, List<Date> dates) {
        String str = node.getAttribute(this.key);
        if (str != null) {
            try {
                Date value;
                try {
                    value = isoDateFormatter.parse(str);
                }
                catch (ParseException ex) {
                    value = isoDateFormatter2.parse(str);
                }
                dates.add(value);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        for (TreeNode child : node.children()) {
            this.collectDatesRecursive((XMLNode)child, dates);
        }
    }

    private void calculateDateHistogramRecursive(TreeNode root) {
        XMLNode node = (XMLNode)root;
        String str = node.getAttribute(this.key);
        if (str != null) {
            try {
                int index;
                Date value;
                try {
                    value = isoDateFormatter.parse(str);
                }
                catch (ParseException ex) {
                    value = isoDateFormatter2.parse(str);
                }
                int n = index = Math.min(this.histogram.length - 1, Math.max(0, (int)((double)((value.getTime() - ((Date)this.min).getTime()) * (long)(this.histogram.length - 1)) / (double)(((Date)this.max).getTime() - ((Date)this.min).getTime()))));
                this.histogram[n] = this.histogram[n] + 1;
            }
            catch (NumberFormatException ex) {
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        for (TreeNode child : root.children()) {
            this.calculateDateHistogramRecursive(child);
        }
    }

    @Override
    public float getWeight(TreePath2 path) {
        XMLNode node = (XMLNode)path.getLastPathComponent();
        String str = node.getAttribute(this.key);
        if (str != null) {
            try {
                Date value;
                try {
                    value = isoDateFormatter.parse(str);
                }
                catch (ParseException ex) {
                    value = isoDateFormatter2.parse(str);
                }
                return (float)(value.getTime() - ((Date)this.min).getTime()) / (float)(((Date)this.max).getTime() - ((Date)this.min).getTime());
            }
            catch (ParseException ex) {
            }
            catch (NumberFormatException ex) {
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    @Override
    public int[] getHistogram() {
        return this.histogram;
    }

    @Override
    public String getMinimumWeightLabel() {
        return this.min.toString();
    }

    @Override
    public String getMaximumWeightLabel() {
        return this.max.toString();
    }

    @Override
    public String getHistogramLabel(int index) {
        long mn = ((Date)this.min).getTime();
        long mx = ((Date)this.max).getTime();
        return DateFormat.getDateTimeInstance().format(new Date((mx - mn) * (long)index / (long)this.histogram.length + mn));
    }

    public float getMedianWeight() {
        Date value = (Date)this.median;
        return (float)(value.getTime() - ((Date)this.min).getTime()) / (float)(((Date)this.max).getTime() - ((Date)this.min).getTime());
    }
}

