/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressView;
import ch.randelshofer.io.BoundedRangeInputStream;
import ch.randelshofer.io.SuspendableInputStream;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.demo.DemoTree;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLNode;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLNodeInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TreevizFileSystemXMLTree
implements DemoTree {
    private TreevizFileSystemXMLNode root;
    private TreevizFileSystemXMLNode filesRoot;
    private TreevizFileSystemXMLNode usersRoot;
    private TreevizFileSystemXMLNodeInfo info;
    ProgressObserver p = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreevizFileSystemXMLTree(File xmlFile) throws IOException {
        if (this.p == null) {
            this.p = new ProgressView("Opening " + xmlFile.getName(), "", 0, 1);
            this.p.setIndeterminate(true);
        }
        try {
            this.root = new TreevizFileSystemXMLNode();
            this.info = new TreevizFileSystemXMLNodeInfo(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputStream in = null;
            try {
                BoundedRangeInputStream bris;
                SAXParser saxParser = factory.newSAXParser();
                if (xmlFile.getName().endsWith(".zip")) {
                    bris = null;
                    in = new FileInputStream(xmlFile);
                    ZipInputStream zis = new ZipInputStream(in);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith(".xml")) {
                            bris = new BoundedRangeInputStream(zis);
                            if (entry.getSize() == -1L) break;
                            bris.setMaximum((int)entry.getSize() + 1);
                            break;
                        }
                        entry = zis.getNextEntry();
                    }
                    if (bris == null) {
                        throw new IOException("No XML file found inside of " + xmlFile + ".");
                    }
                } else {
                    in = new FileInputStream(xmlFile);
                    bris = new BoundedRangeInputStream(in);
                    bris.setMaximum((int)xmlFile.length() + 1);
                }
                final SuspendableInputStream sis = new SuspendableInputStream(bris);
                this.p.setModel(bris);
                this.p.setIndeterminate(false);
                this.p.setDoCancel(new Runnable(){

                    public void run() {
                        sis.abort();
                    }
                });
                Charset cs = Charset.forName("UTF-8");
                CharsetDecoder decoder = cs.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPLACE);
                InputStreamReader isr = new InputStreamReader((InputStream)sis, decoder);
                saxParser.parse(new InputSource(isr), new DefaultHandler(){
                    private boolean isFirstElement = true;
                    private Stack<TreevizFileSystemXMLNode> stack = new Stack();
                    {
                        this.stack.push(TreevizFileSystemXMLTree.this.root);
                    }

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (this.isFirstElement) {
                            this.isFirstElement = false;
                            if (!qName.equals("TreevizFileSystem")) {
                                throw new SAXException("Illegal root element: \"" + qName + "\" must be \"TreevizFileSystem\"");
                            }
                        }
                        TreevizFileSystemXMLNode node = new TreevizFileSystemXMLNode();
                        node.setName(qName.intern());
                        int n = attributes.getLength();
                        for (int i = 0; i < n; ++i) {
                            String name = attributes.getQName(i).intern();
                            node.putAttribute(name, attributes.getValue(i));
                        }
                        this.stack.peek().addChild(node);
                        this.stack.push(node);
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        this.stack.pop();
                    }
                });
            }
            catch (ParserConfigurationException ex) {
                IOException iex = new IOException("XML Parser configuration error");
                iex.initCause(ex);
                throw iex;
            }
            catch (SAXException ex) {
                IOException iex = new IOException("XML Error");
                iex.initCause(ex);
                throw iex;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (this.root.children().size() != 1) {
                throw new IOException("XML File is empty");
            }
            TreeNode rootElement = this.root.children().get(0);
            if (rootElement.children().size() != 2) {
                throw new IOException("TreevizFileSystem element must have two children");
            }
            this.usersRoot = (TreevizFileSystemXMLNode)rootElement.children().get(0);
            if (!this.usersRoot.getName().equals("Users")) {
                throw new IOException("First child of TreevizFileSystem element \"" + this.usersRoot.getName() + "\" must be named \"Users\"");
            }
            this.filesRoot = (TreevizFileSystemXMLNode)rootElement.children().get(1);
            if (!this.filesRoot.getName().equals("Files")) {
                throw new IOException("Second child of TreevizFileSystem element \"" + this.filesRoot.getName() + "\" must be named \"Files\"");
            }
        }
        finally {
            this.p.close();
        }
    }

    public TreevizFileSystemXMLNode getRoot() {
        return this.filesRoot;
    }

    public TreevizFileSystemXMLNode getUsersRoot() {
        return this.usersRoot;
    }

    public TreevizFileSystemXMLNodeInfo getInfo() {
        return this.info;
    }
}

