/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.AbstractNodeInfo;
import ch.randelshofer.tree.demo.RGBColorizer;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLInfoWeighter;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLNode;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLTree;
import ch.randelshofer.util.FileSizeFormat;
import java.awt.Color;
import java.awt.Image;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreevizFileSystemXMLNodeInfo
extends AbstractNodeInfo {
    private FileSizeFormat shortWeightFormat;
    private FileSizeFormat longWeightFormat;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent;
    private Colorizer colorizer = new RGBColorizer();
    private Weighter colorWeighter;
    private Weighter weighter;
    private HashMap<String, TreevizFileSystemXMLNode> selectedUsers;
    private boolean isInitialized = false;
    private HashMap<String, HashSet<String>> attributes = new HashMap();
    private HashMap<String, AbstractNodeInfo.DataType> types;
    private HashMap<String, HashSet<String>> userAttributes;
    private HashMap<String, TreevizFileSystemXMLNode> userMap;
    private HashMap<String, AbstractNodeInfo.DataType> userTypes;
    private String nameAttribute;
    private String weightAttribute;
    private String colorAttribute;
    private TreevizFileSystemXMLTree tree;
    private static NumberFormat intFormat = DecimalFormat.getIntegerInstance();
    private static NumberFormat shortDecFormat = (NumberFormat)DecimalFormat.getNumberInstance().clone();

    public TreevizFileSystemXMLNodeInfo(TreevizFileSystemXMLTree tree) {
        this.tree = tree;
        this.shortWeightFormat = new FileSizeFormat();
        this.shortWeightFormat.setShortFormat(true);
        this.shortWeightFormat.setMaximumFractionDigits(0);
        this.longWeightFormat = new FileSizeFormat();
        this.longWeightFormat.setMaximumFractionDigits(1);
        this.longWeightFormat.setAlwaysIncludeBytes(true);
    }

    @Override
    public String getName(TreePath2<TreeNode> path) {
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        if (this.nameAttribute != null && node.getAttribute(this.nameAttribute) != null) {
            return node.getAttribute(this.nameAttribute).toString();
        }
        return node.getName();
    }

    @Override
    public Color getColor(TreePath2<TreeNode> path) {
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        return !this.isNodeSelected(node) || this.colorizer == null || this.colorWeighter == null ? Color.WHITE : this.colorizer.get(this.colorWeighter.getWeight(path));
    }

    @Override
    public long getWeight(TreePath2<TreeNode> path) {
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        if (!node.getAllowsChildren() && this.weightAttribute != null && node.getAttribute(this.weightAttribute) != null) {
            return Math.max(1L, Long.valueOf(node.getAttribute(this.weightAttribute).toString()));
        }
        return Math.max(1L, node.getCumulatedWeight());
    }

    public long getAccumulatedWeight(TreePath2<TreeNode> path) {
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        return node.getCumulatedWeight();
    }

    @Override
    public String getTooltip(TreePath2<TreeNode> path) {
        String key;
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        String ownerAttr = "ownerRef";
        TreevizFileSystemXMLNode userNode = this.userMap.get(node.getAttribute(ownerAttr));
        StringBuilder buf = new StringBuilder();
        TreePath2 parentPath = path;
        buf.insert(0, "</b><br>");
        buf.insert(0, this.getName(parentPath));
        buf.insert(0, "<b>");
        for (parentPath = parentPath.getParentPath(); parentPath != null && parentPath.getPathCount() > 1; parentPath = parentPath.getParentPath()) {
            buf.insert(0, "<br>");
            buf.insert(0, this.getName(parentPath));
        }
        buf.insert(0, "<html>");
        buf.append("<br>type: ").append(node.getName());
        buf.append("<br><b>size: ").append(this.longWeightFormat.format(node.getCumulatedWeight())).append("</b>");
        if (node.getAllowsChildren()) {
            buf.append("<br>children: ");
            buf.append(intFormat.format(node.children().size()));
            buf.append("<br>descendants: ");
            buf.append(intFormat.format(node.getDescendantCount()));
        }
        HashMap<String, Object> attr = node.getAttributes();
        TreeMap<String, Object> orderedMap = new TreeMap<String, Object>(attr);
        for (Map.Entry<String, Object> entry : orderedMap.entrySet()) {
            key = entry.getKey();
            if (key.equals(ownerAttr) || key.equals("name") || key.equals("size")) continue;
            buf.append("<br>").append(key).append(": ");
            if (key.toLowerCase().endsWith("size") && this.types.get(key) == AbstractNodeInfo.DataType.NUMERIC_STRING) {
                buf.append(this.longWeightFormat.format(Long.valueOf(entry.getValue().toString())));
                continue;
            }
            buf.append(entry.getValue());
        }
        buf.append("<br><br>owner: ");
        buf.append(node.getAttribute(ownerAttr));
        if (userNode != null) {
            attr = userNode.getAttributes();
            orderedMap = new TreeMap<String, Object>(attr);
            for (Map.Entry<String, Object> entry : orderedMap.entrySet()) {
                key = entry.getKey();
                if (attr.containsKey("name") && (key.equals("firstname") || key.equals("lastname")) || key.equals("id")) continue;
                buf.append("<br>" + key + ": ");
                if (key.equals("name")) {
                    buf.insert(buf.length() - key.length() - 2, "<b>");
                    buf.append(entry.getValue());
                    buf.append(',');
                    if (attr.containsKey("firstname")) {
                        buf.append(' ');
                        buf.append(attr.get("firstname"));
                    }
                    if (attr.containsKey("lastname")) {
                        buf.append(' ');
                        buf.append(attr.get("lastname"));
                    }
                    buf.append("</b>");
                    continue;
                }
                if (key.toLowerCase().endsWith("size") && this.userTypes.get(key) == AbstractNodeInfo.DataType.NUMERIC_STRING) {
                    buf.append(this.longWeightFormat.format(Long.valueOf(entry.getValue().toString())));
                    continue;
                }
                if (this.userTypes.get(key) == AbstractNodeInfo.DataType.LONG) {
                    buf.append(this.longWeightFormat.format((Long)entry.getValue()));
                    continue;
                }
                buf.append(entry.getValue());
            }
        }
        return buf.toString();
    }

    @Override
    public Image getImage(TreePath2<TreeNode> path) {
        TreevizFileSystemXMLNode node = (TreevizFileSystemXMLNode)path.getLastPathComponent();
        return null;
    }

    @Override
    public Weighter getWeighter() {
        return this.colorWeighter;
    }

    @Override
    public Colorizer getColorizer() {
        return this.colorizer;
    }

    @Override
    public void init(TreeNode root) {
        this.init((TreevizFileSystemXMLNode)root);
    }

    public void init(TreevizFileSystemXMLNode root) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.userTypes = new HashMap();
            this.userAttributes = new HashMap();
            this.types = new HashMap();
            this.attributes = new HashMap();
            this.computeBasicStats(this.tree.getUsersRoot(), this.userTypes, this.userAttributes);
            this.computeBasicStats(root, this.types, this.attributes);
            this.computeFilesStats(root);
            this.computeUserStats(this.tree.getUsersRoot(), root);
        }
    }

    public void computeBasicStats(TreevizFileSystemXMLNode root, HashMap<String, AbstractNodeInfo.DataType> typeMap, HashMap<String, HashSet<String>> attrMap) {
        this.collectAttributesRecursively(root, attrMap);
        for (Map.Entry<String, HashSet<String>> entry : attrMap.entrySet()) {
            typeMap.put(entry.getKey(), this.determineDataType((Set<String>)entry.getValue()));
        }
        this.nameAttribute = null;
        if (typeMap.get("name") != null) {
            this.nameAttribute = "name";
        } else {
            for (Map.Entry<String, Object> entry : typeMap.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.TEXT_STRING || this.nameAttribute != null && this.nameAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.nameAttribute = entry.getKey();
            }
        }
    }

    private void computeFilesStats(TreevizFileSystemXMLNode root) {
        this.weightAttribute = null;
        if (this.types.get("size") == AbstractNodeInfo.DataType.NUMERIC_STRING) {
            this.weightAttribute = "size";
        } else {
            for (Map.Entry<String, AbstractNodeInfo.DataType> entry : this.types.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.NUMERIC_STRING || this.weightAttribute != null && this.weightAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.weightAttribute = entry.getKey();
            }
        }
        this.weighter = new TreevizFileSystemXMLInfoWeighter(this, this.weightAttribute);
        root.accumulateWeights(this, null);
        this.colorAttribute = null;
        if (this.types.get("created") == AbstractNodeInfo.DataType.DATE_STRING) {
            this.colorAttribute = "created";
        } else {
            for (Map.Entry<String, AbstractNodeInfo.DataType> entry : this.types.entrySet()) {
                if (entry.getValue() != AbstractNodeInfo.DataType.DATE_STRING || this.colorAttribute != null && this.colorAttribute.compareTo(entry.getKey()) <= 0) continue;
                this.colorAttribute = entry.getKey();
            }
        }
        if (this.colorAttribute == null) {
            this.weighter = null;
        } else {
            this.colorWeighter = new TreevizFileSystemXMLInfoWeighter(this, this.colorAttribute);
            this.colorWeighter.init(root);
        }
        this.colorizer = new RGBColorizer(new float[]{0.0f, ((TreevizFileSystemXMLInfoWeighter)this.colorWeighter).getMedianWeight(), 1.0f}, new Color[]{new Color(6605055), new Color(0xF0F0F0), new Color(16750918)});
    }

    public void collectAttributesRecursively(TreevizFileSystemXMLNode node, HashMap<String, HashSet<String>> attrMap) {
        for (Map.Entry<String, Object> entry : node.getAttributes().entrySet()) {
            HashSet<Object> valueSet;
            String value;
            String key = entry.getKey();
            Object obj = entry.getValue();
            String string = value = obj != null ? obj.toString() : null;
            if (attrMap.containsKey(key)) {
                valueSet = attrMap.get(key);
            } else {
                valueSet = new HashSet();
                attrMap.put(key, valueSet);
            }
            valueSet.add(value);
        }
        for (TreeNode child : node.children()) {
            this.collectAttributesRecursively((TreevizFileSystemXMLNode)child, attrMap);
        }
    }

    public void computeUserStats(TreevizFileSystemXMLNode usersRoot, TreevizFileSystemXMLNode filesRoot) {
        this.userMap = new HashMap();
        String idAttr = "id";
        for (TreeNode child : usersRoot.children()) {
            TreevizFileSystemXMLNode userNode = (TreevizFileSystemXMLNode)child;
            if (userNode.getAttribute(idAttr) != null) {
                this.userMap.put(userNode.getAttribute(idAttr).toString(), userNode);
            }
            userNode.putAttribute("disk usage", null);
            userNode.putAttribute("owned objects", null);
        }
        this.userTypes.put("disk usage", AbstractNodeInfo.DataType.LONG);
        this.userTypes.put("owned objects", AbstractNodeInfo.DataType.INTEGER);
        this.computeUserFileStatsRecursive(filesRoot);
    }

    public void computeUserFileStatsRecursive(TreevizFileSystemXMLNode filesNode) {
        TreevizFileSystemXMLNode userNode;
        if (filesNode.getAttribute("ownerRef") != null && (userNode = this.userMap.get(filesNode.getAttribute("ownerRef"))) != null) {
            Integer count;
            if (filesNode.children().size() == 0) {
                Long weight = (Long)userNode.getAttribute("disk usage");
                userNode.putAttribute("disk usage", weight == null ? 1L : weight + filesNode.getCumulatedWeight());
                userNode.setCumulatedWeight(userNode.getCumulatedWeight() + filesNode.getCumulatedWeight());
            }
            userNode.putAttribute("owned objects", (count = (Integer)userNode.getAttribute("owned objects")) == null ? 1 : count + 1);
        }
        for (TreeNode child : filesNode.children()) {
            this.computeUserFileStatsRecursive((TreevizFileSystemXMLNode)child);
        }
    }

    public AbstractNodeInfo.DataType getType(String key) {
        return this.types.get(key);
    }

    public Set<String> getValues(String key) {
        return this.attributes.get(key);
    }

    public boolean isNodeSelected(TreevizFileSystemXMLNode node) {
        if (this.selectedUsers == null || this.selectedUsers.isEmpty()) {
            return true;
        }
        Object ref = node.getAttribute("ownerRef");
        return this.selectedUsers.containsKey(ref);
    }

    public void setSelectedUsers(HashMap<String, TreevizFileSystemXMLNode> newValue) {
        this.selectedUsers = newValue;
        this.fireStateChanged();
    }

    public TableModel getUserTable() {
        ArrayList<TreevizFileSystemXMLNode> rows = new ArrayList<TreevizFileSystemXMLNode>();
        rows.addAll(this.userMap.values());
        Collections.sort(rows, new Comparator<TreevizFileSystemXMLNode>(){

            @Override
            public int compare(TreevizFileSystemXMLNode o1, TreevizFileSystemXMLNode o2) {
                long diff = o2.getCumulatedWeight() - o1.getCumulatedWeight();
                if (diff > 0L) {
                    return 1;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<String> columns = new ArrayList<String>();
        columns.addAll(this.userTypes.keySet());
        Collections.sort(columns);
        String[] preferredOrder = new String[]{"id", "name", "firstname", "lastname", "email", "matriculation", "created", "expired", "isActive", "used"};
        for (int i = preferredOrder.length - 1; i >= 0; --i) {
            if (!columns.contains(preferredOrder[i])) continue;
            columns.remove(preferredOrder[i]);
            columns.add(0, preferredOrder[i]);
        }
        return new InfoTableModel(rows, columns);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return this.shortWeightFormat.format(this.getWeight(path));
    }

    static {
        shortDecFormat.setMaximumFractionDigits(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InfoTableModel
    extends AbstractTableModel {
        private ArrayList<TreevizFileSystemXMLNode> rows;
        private ArrayList<String> columns = new ArrayList();

        public InfoTableModel(ArrayList<TreevizFileSystemXMLNode> rows, ArrayList<String> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columns.get(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch ((AbstractNodeInfo.DataType)((Object)TreevizFileSystemXMLNodeInfo.this.userTypes.get(this.columns.get(columnIndex)))) {
                case LONG: {
                    return Long.class;
                }
                case INTEGER: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex).getAttribute(this.columns.get(columnIndex));
        }

        public TreevizFileSystemXMLNode getRowObject(int row) {
            return this.rows.get(row);
        }
    }
}

