/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreevizFileSystemXMLNode
implements TreeNode {
    private ArrayList<TreevizFileSystemXMLNode> children;
    private String name;
    private HashMap<String, Object> attributes = new HashMap();
    private long cumulatedWeight;
    private int descendants = -1;

    @Override
    public List<TreeNode> children() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    public void addChild(TreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add((TreevizFileSystemXMLNode)child);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.children != null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void putAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public long getCumulatedWeight() {
        return this.cumulatedWeight;
    }

    public void setCumulatedWeight(long newValue) {
        this.cumulatedWeight = newValue;
    }

    public void accumulateWeights(NodeInfo info, TreePath2 path) {
        TreePath2<TreeNode> myPath = path == null ? new TreePath2<TreeNode>(this) : path.pathByAddingChild(this);
        this.cumulatedWeight = info.getWeight(myPath);
        if (this.children != null) {
            for (TreevizFileSystemXMLNode child : this.children) {
                child.accumulateWeights(info, myPath);
                this.cumulatedWeight += child.getCumulatedWeight();
            }
        }
    }

    public int getDescendantCount() {
        if (this.descendants == -1) {
            this.descendants = 0;
            if (this.children != null) {
                this.descendants += this.children.size();
                for (TreevizFileSystemXMLNode child : this.children) {
                    this.descendants += child.getDescendantCount();
                }
            }
        }
        return this.descendants;
    }
}

