/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import java.awt.Color;

public class RGBColorizer
implements Colorizer {
    private float[] fractions;
    private int[] reds;
    private int[] greens;
    private int[] blues;

    public RGBColorizer() {
        this(new Color[]{new Color(6605055), new Color(0xF0F0F0), new Color(16750918)});
    }

    public RGBColorizer(Color[] colors) {
        this.fractions = new float[colors.length];
        this.reds = new int[colors.length];
        this.greens = new int[colors.length];
        this.blues = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            this.fractions[i] = (float)i / (float)(colors.length - 1);
            this.reds[i] = colors[i].getRed();
            this.greens[i] = colors[i].getGreen();
            this.blues[i] = colors[i].getBlue();
        }
    }

    public RGBColorizer(float[] fractions, Color[] colors) {
        this.fractions = fractions;
        this.reds = new int[colors.length];
        this.greens = new int[colors.length];
        this.blues = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            this.reds[i] = colors[i].getRed();
            this.greens[i] = colors[i].getGreen();
            this.blues[i] = colors[i].getBlue();
        }
    }

    public Color get(float value) {
        int i;
        for (i = 0; i < this.fractions.length && !(this.fractions[i] > value); ++i) {
        }
        if (i == 0) {
            return new Color(this.reds[i], this.greens[i], this.blues[i]);
        }
        if (i == this.fractions.length) {
            return new Color(this.reds[i - 1], this.greens[i - 1], this.blues[i - 1]);
        }
        int startR = this.reds[i - 1];
        int startG = this.greens[i - 1];
        int startB = this.blues[i - 1];
        int endR = this.reds[i];
        int endG = this.greens[i];
        int endB = this.blues[i];
        float range = this.fractions[i] - this.fractions[i - 1];
        float scaledValue = (value - this.fractions[i - 1]) / range;
        return new Color((int)((float)startR * (1.0f - scaledValue) + scaledValue * (float)endR), (int)((float)startG * (1.0f - scaledValue) + scaledValue * (float)endG), (int)((float)startB * (1.0f - scaledValue) + scaledValue * (float)endB));
    }
}

