/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.demo.DemoTree;
import ch.randelshofer.tree.demo.ManyEyesCompositeNode;
import ch.randelshofer.tree.demo.ManyEyesNode;
import ch.randelshofer.tree.demo.ManyEyesNodeInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyEyesTree
implements DemoTree {
    private ManyEyesCompositeNode root;
    private String[] headers;
    private int[] pathIndices;
    private ArrayList<ManyEyesNode> nodes;
    private ManyEyesNodeInfo info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManyEyesTree(File manyEyesFile) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(manyEyesFile), "UTF-8"));
            Pattern pattern = Pattern.compile(" *\t *");
            String line = r.readLine();
            this.headers = pattern.split(line);
            Object[] values = new String[this.headers.length];
            Arrays.fill(values, "");
            this.root = new ManyEyesCompositeNode((String[])values);
            this.root.setName(manyEyesFile.getName().substring(0, manyEyesFile.getName().length() - 4));
            this.nodes = new ArrayList();
            while ((line = r.readLine()) != null) {
                values = pattern.split(line);
                ManyEyesNode node = new ManyEyesNode((String[])values);
                this.nodes.add(node);
            }
            this.createDefaultTreeStructure();
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int[] getPathIndices() {
        return this.pathIndices;
    }

    public ArrayList<ManyEyesNode> getNodes() {
        return this.nodes;
    }

    public void createDefaultTreeStructure() {
        int length;
        for (length = 1; length < this.headers.length && this.headers[0].equals(this.headers[length]); ++length) {
        }
        int[] indices = new int[length];
        for (int i = 0; i < length; ++i) {
            indices[i] = i;
        }
        this.createTreeStructure(indices);
    }

    public void createTreeStructure(final int[] pathIndices) {
        this.pathIndices = pathIndices;
        ArrayList sorted = (ArrayList)this.nodes.clone();
        Collections.sort(sorted, new Comparator<ManyEyesNode>(){

            @Override
            public int compare(ManyEyesNode n1, ManyEyesNode n2) {
                String[] v1 = n1.getValues();
                String[] v2 = n2.getValues();
                for (int i = 0; i < pathIndices.length; ++i) {
                    int c = v1[pathIndices[i]].compareTo(v2[pathIndices[i]]);
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }
        });
        this.root.removeAllChildren();
        ManyEyesCompositeNode parent = this.root;
        for (ManyEyesNode node : sorted) {
            if (!this.isDescendantOf(node, parent) && parent != this.root) {
                ManyEyesNode child = (ManyEyesNode)parent.children().get(0);
                ManyEyesCompositeNode grandParent = parent.getParent();
                grandParent.remove(parent);
                grandParent.add(child);
                parent = grandParent;
            }
            while (!this.isDescendantOf(node, parent)) {
                parent = parent.getParent();
            }
            int nodeDepth = this.getDepth(node);
            for (int parentDepth = this.getDepth(parent); nodeDepth > parentDepth; ++parentDepth) {
                Object[] artificial = new String[this.headers.length];
                Arrays.fill(artificial, "");
                String[] nv = node.getValues();
                for (int i = 0; i <= parentDepth; ++i) {
                    artificial[pathIndices[i]] = nv[pathIndices[i]];
                }
                ManyEyesCompositeNode newParent = new ManyEyesCompositeNode((String[])artificial);
                parent.add(newParent);
                newParent.setName((String)artificial[pathIndices[parentDepth]]);
                parent = newParent;
            }
            node.setName(node.getValues()[pathIndices[nodeDepth - 1]]);
            System.out.println("adding " + node + " to " + parent);
            parent.add(node);
        }
        if (parent != this.root) {
            ManyEyesNode child = (ManyEyesNode)parent.children().get(0);
            ManyEyesCompositeNode grandParent = parent.getParent();
            grandParent.remove(parent);
            grandParent.add(child);
        }
    }

    private boolean isDescendantOf(ManyEyesNode n1, ManyEyesNode n2) {
        if (n2 == this.root) {
            return true;
        }
        String[] v1 = n1.getValues();
        String[] v2 = n2.getValues();
        for (int i = 0; i < this.pathIndices.length && v2[this.pathIndices[i]].length() > 0; ++i) {
            System.out.print("." + v1[this.pathIndices[i]]);
            if (v1[this.pathIndices[i]].equals(v2[this.pathIndices[i]])) continue;
            System.out.println("#");
            return false;
        }
        System.out.println();
        return true;
    }

    private int getDepth(ManyEyesNode n1) {
        int i;
        String[] v1 = n1.getValues();
        for (i = 0; i < this.pathIndices.length && v1[this.pathIndices[i]].length() > 0 && !v1[this.pathIndices[i]].equals("-"); ++i) {
        }
        return i;
    }

    @Override
    public TreeNode getRoot() {
        return this.root;
    }

    @Override
    public NodeInfo getInfo() {
        if (this.info == null) {
            this.info = new ManyEyesNodeInfo(this);
        }
        return this.info;
    }
}

