/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.AbstractNodeInfo;
import ch.randelshofer.tree.demo.ManyEyesNode;
import ch.randelshofer.tree.demo.ManyEyesTree;
import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyEyesNodeInfo
extends AbstractNodeInfo {
    private ManyEyesTree tree;
    private HashMap<String, AbstractNodeInfo.DataType> types;
    private HashMap<String, HashSet<String>> attributes;
    private int weightAttributeIndex = -1;
    private int colorAttributeIndex = -1;
    private int[] pathIndices = null;

    public ManyEyesNodeInfo(ManyEyesTree tree) {
        this.tree = tree;
    }

    @Override
    public void init(TreeNode root) {
        this.types = new HashMap();
        this.attributes = new HashMap();
        this.computeBasicStats(this.tree.getNodes(), this.types, this.attributes);
    }

    public void computeBasicStats(ArrayList<ManyEyesNode> nodes, HashMap<String, AbstractNodeInfo.DataType> typeMap, HashMap<String, HashSet<String>> attrMap) {
        int length;
        int i;
        this.collectAttributes(nodes, attrMap);
        for (Map.Entry<String, HashSet<String>> entry : attrMap.entrySet()) {
            typeMap.put(entry.getKey(), this.determineDataType((Set<String>)entry.getValue()));
        }
        String[] headers = this.tree.getHeaders();
        this.weightAttributeIndex = -1;
        for (i = 0; i < headers.length; ++i) {
            if (typeMap.get(headers[i]) != AbstractNodeInfo.DataType.NUMERIC_STRING) continue;
            this.weightAttributeIndex = i;
            break;
        }
        this.colorAttributeIndex = -1;
        for (i = this.weightAttributeIndex + 1; i < headers.length; ++i) {
            if (typeMap.get(headers[i]) != AbstractNodeInfo.DataType.NUMERIC_STRING && typeMap.get(headers[i]) != AbstractNodeInfo.DataType.DATE_STRING) continue;
            this.colorAttributeIndex = i;
            break;
        }
        for (length = 1; length < headers.length && typeMap.get(headers[0]) == typeMap.get(headers[length]); ++length) {
        }
        int[] indices = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            indices[i2] = i2;
        }
        if (!Arrays.equals(indices, this.tree.getPathIndices())) {
            this.tree.createTreeStructure(indices);
        }
    }

    public void collectAttributes(ArrayList<ManyEyesNode> nodes, HashMap<String, HashSet<String>> attrMap) {
        String[] headers = this.tree.getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            HashSet valueSet = new HashSet();
            attrMap.put(headers[i], valueSet);
        }
        for (ManyEyesNode node : nodes) {
            String[] values = node.getValues();
            for (int i = 0; i < headers.length; ++i) {
                HashSet<String> valueSet = attrMap.get(headers[i]);
                valueSet.add(values[i]);
            }
        }
    }

    @Override
    public String getName(TreePath2<TreeNode> path) {
        ManyEyesNode node = (ManyEyesNode)path.getLastPathComponent();
        return node.getName();
    }

    @Override
    public Color getColor(TreePath2<TreeNode> path) {
        return Color.GRAY;
    }

    @Override
    public long getWeight(TreePath2<TreeNode> path) {
        if (this.weightAttributeIndex == -1) {
            return 1L;
        }
        ManyEyesNode node = (ManyEyesNode)path.getLastPathComponent();
        String[] values = node.getValues();
        try {
            return Long.valueOf(values[this.weightAttributeIndex]);
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    @Override
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return Long.valueOf(this.getWeight(path)).toString();
    }

    @Override
    public String getTooltip(TreePath2<TreeNode> path) {
        ManyEyesNode node = (ManyEyesNode)path.getLastPathComponent();
        StringBuilder buf = new StringBuilder();
        TreePath2 parentPath = path;
        buf.insert(0, "</b><br>");
        buf.insert(0, this.getName(parentPath));
        buf.insert(0, "<b>");
        for (parentPath = parentPath.getParentPath(); parentPath != null && parentPath.getPathCount() > 1; parentPath = parentPath.getParentPath()) {
            buf.insert(0, "<br>");
            buf.insert(0, this.getName(parentPath));
        }
        buf.insert(0, "<html>");
        String[] headers = this.tree.getHeaders();
        int[] pathIndices = this.tree.getPathIndices();
        String[] values = node.getValues();
        block1: for (int i = 0; i < headers.length; ++i) {
            for (int j = 0; j < pathIndices.length; ++j) {
                if (i == pathIndices[j]) continue block1;
            }
            buf.append("<br>").append(headers[i]).append(": ").append(values[i]);
        }
        return buf.toString();
    }

    @Override
    public Image getImage(TreePath2<TreeNode> path) {
        return null;
    }

    @Override
    public Weighter getWeighter() {
        return null;
    }

    @Override
    public Colorizer getColorizer() {
        return null;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
    }
}

