/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.gui.ProgressView;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.circlemap.CirclemapModel;
import ch.randelshofer.tree.circlemap.CirclemapView;
import ch.randelshofer.tree.demo.DemoTree;
import ch.randelshofer.tree.demo.FileNode;
import ch.randelshofer.tree.demo.FileNodeInfo;
import ch.randelshofer.tree.demo.JHistogram;
import ch.randelshofer.tree.demo.ManyEyesTree;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLNode;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLNodeInfo;
import ch.randelshofer.tree.demo.TreevizFileSystemXMLTree;
import ch.randelshofer.tree.demo.XMLTree;
import ch.randelshofer.tree.hypertree.HyperTree;
import ch.randelshofer.tree.hypertree.SwingHTView;
import ch.randelshofer.tree.rectmap.RectmapModel;
import ch.randelshofer.tree.rectmap.RectmapView;
import ch.randelshofer.tree.sunburst.IcicleModel;
import ch.randelshofer.tree.sunburst.IcicleView;
import ch.randelshofer.tree.sunburst.SunburstModel;
import ch.randelshofer.tree.sunburst.SunburstView;
import ch.randelshofer.tree.sunray.IcerayModel;
import ch.randelshofer.tree.sunray.IcerayView;
import ch.randelshofer.tree.sunray.SunrayModel;
import ch.randelshofer.tree.sunray.SunrayView;
import ch.randelshofer.util.FileSizeFormat;
import ch.randelshofer.util.Methods;
import ch.randelshofer.util.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class Main
extends JFrame {
    private TreeView treeView;
    private JFileChooser directoryChooser;
    private JFileChooser fileChooser;
    private File rootFile;
    private TreeNode rootNode;
    private Preferences prefs;
    private NodeInfo info;
    private DropTargetListener dropHandler = new DropTargetListener(){

        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent event) {
            block6: {
                if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    event.acceptDrop(1);
                    try {
                        List files = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        if (files.size() != 1) break block6;
                        File file = (File)files.get(0);
                        if (file.isDirectory()) {
                            Main.this.openDirectory(file);
                            break block6;
                        }
                        Main.this.openFile(file);
                    }
                    catch (IOException e) {
                        JOptionPane.showConfirmDialog(Main.this, "Could not access the dropped data.", "Treeviz: Drop Failed", -1, 1);
                    }
                    catch (UnsupportedFlavorException e) {
                        JOptionPane.showConfirmDialog(Main.this, "Unsupported data flavor.", "Treeviz: Drop Failed", -1, 1);
                    }
                } else {
                    event.rejectDrop();
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent event) {
        }
    };
    private JMenuItem aboutMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JHistogram histogram;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JRadioButton maxDepth1Radio;
    private ButtonGroup maxDepthButtonGroup;
    private JRadioButton maxDepthInfinityRadio;
    private JPanel maxDepthPanel;
    private JMenuItem openDirectoryMenuItem;
    private JMenuItem openFileMenuItem;
    private JPanel statusPanel;
    private JCheckBoxMenuItem toolTipEnabledRadio;
    private ButtonGroup viewAsButtonGroup;
    private JRadioButtonMenuItem viewAsCircleMapRadio;
    private JRadioButtonMenuItem viewAsHypertreeRadio;
    private JRadioButtonMenuItem viewAsIcerayRadio;
    private JRadioButtonMenuItem viewAsIcicleRadio;
    private JRadioButtonMenuItem viewAsRectangleMapRadio;
    private JRadioButtonMenuItem viewAsSunburstRadio;
    private JRadioButtonMenuItem viewAsSunrayRadio;
    private JMenu viewMenu;
    private JPanel viewPanel;

    public Main() {
        this.initComponents();
        this.setSize(400, 400);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.viewAsHypertreeRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("hyperbolic"));
        this.viewAsSunburstRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("sunburst"));
        this.viewAsSunrayRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("sunray"));
        this.viewAsIcicleRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("icicle"));
        this.viewAsIcerayRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("iceray"));
        this.viewAsCircleMapRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("circlemap"));
        this.viewAsRectangleMapRadio.setSelected(this.prefs.get("viewAs", "hyperbolic").equals("rectanglemap"));
        this.toolTipEnabledRadio.setSelected(this.prefs.getBoolean("toolTipEnabled", true));
        this.updateMaxDepth();
        new DropTarget(this, this.dropHandler);
        new DropTarget(this.getContentPane(), this.dropHandler);
        new DropTarget(this.viewPanel, this.dropHandler);
        this.statusPanel.setVisible(false);
    }

    private void updateView() {
        if (this.rootNode == null) {
            this.viewPanel.removeAll();
            this.statusPanel.setVisible(false);
            this.validate();
            this.repaint();
        } else {
            this.statusPanel.setVisible(true);
            if (this.viewAsHypertreeRadio.isSelected()) {
                this.updateHTView();
            } else if (this.viewAsSunburstRadio.isSelected()) {
                this.updateSBView();
            } else if (this.viewAsSunrayRadio.isSelected()) {
                this.updateScBView();
            } else if (this.viewAsIcicleRadio.isSelected()) {
                this.updateIcView();
            } else if (this.viewAsIcerayRadio.isSelected()) {
                this.updateIdView();
            } else if (this.viewAsCircleMapRadio.isSelected()) {
                this.updateCMView();
            } else if (this.viewAsRectangleMapRadio.isSelected()) {
                this.updateRMView();
            }
        }
    }

    private void updateToolTipEnabled() {
        if (this.treeView != null) {
            this.treeView.setToolTipEnabled(this.prefs.getBoolean("toolTipEnabled", true));
        }
    }

    private void updateMaxDepth() {
        this.maxDepthPanel.setVisible(this.treeView instanceof RectmapView || this.treeView instanceof CirclemapView);
        this.maxDepthPanel.revalidate();
        if (this.treeView != null) {
            this.treeView.setMaxDepth(this.prefs.getInt("maxDepth", Integer.MAX_VALUE));
        }
        switch (this.prefs.getInt("maxDepth", Integer.MAX_VALUE)) {
            case 1: {
                this.maxDepth1Radio.setSelected(true);
                break;
            }
            default: {
                this.maxDepthInfinityRadio.setSelected(true);
            }
        }
    }

    private void updateSBView() {
        final ProgressView p = new ProgressView("Sunburst Tree", "Calculating layout...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                SunburstModel sunbursttree = new SunburstModel(Main.this.rootNode, Main.this.info);
                return sunbursttree;
            }

            public void done(Object o) {
                SunburstModel model = (SunburstModel)o;
                SunburstView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                Main.this.treeView = view;
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateScBView() {
        final ProgressView p = new ProgressView("Sunray Tree", "Calculating layout...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                SunrayModel scatterbursttree = new SunrayModel(Main.this.rootNode, Main.this.info);
                return scatterbursttree;
            }

            public void done(Object o) {
                SunrayModel model = (SunrayModel)o;
                SunrayView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateHTView() {
        final ProgressView p = new ProgressView("Hyperbolic Tree", "Calculating layout...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                HyperTree tree = new HyperTree(Main.this.rootNode, Main.this.info);
                return tree;
            }

            public void done(Object o) {
                HyperTree model = (HyperTree)o;
                SwingHTView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateCMView() {
        final ProgressView p = new ProgressView("Circular Treemap", "Initializing...");
        p.setCancelable(true);
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                CirclemapModel model = new CirclemapModel(Main.this.rootNode, Main.this.info, p);
                return model;
            }

            public void done(Object o) {
                if (p.isCanceled()) {
                    return;
                }
                CirclemapModel model = (CirclemapModel)o;
                CirclemapView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateRMView() {
        final ProgressView p = new ProgressView("Rectangular Treemap", "Initializing...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                RectmapModel model = new RectmapModel(Main.this.rootNode, Main.this.info, p);
                return model;
            }

            public void done(Object o) {
                if (p.isCanceled()) {
                    return;
                }
                RectmapModel model = (RectmapModel)o;
                RectmapView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateIcView() {
        final ProgressView p = new ProgressView("Icicle Tree", "Calculating layout...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                IcicleModel tree = new IcicleModel(Main.this.rootNode, Main.this.info);
                return tree;
            }

            public void done(Object o) {
                IcicleModel model = (IcicleModel)o;
                IcicleView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private void updateIdView() {
        final ProgressView p = new ProgressView("Iceray Tree", "Calculating layout...");
        p.setIndeterminate(true);
        Worker worker = new Worker(){

            public Object construct() {
                IcerayModel tree = new IcerayModel(Main.this.rootNode, Main.this.info);
                return tree;
            }

            public void done(Object o) {
                IcerayModel model = (IcerayModel)o;
                IcerayView view = model.getView();
                Main.this.treeView = view;
                Main.this.histogram.setWeighter(model.getInfo().getWeighter());
                Main.this.histogram.setColorizer(model.getInfo().getColorizer());
                Main.this.viewPanel.removeAll();
                if (Main.this.info instanceof TreevizFileSystemXMLNodeInfo) {
                    JSplitPane splitPane = Main.this.createSplitPane(view);
                    Main.this.viewPanel.add(splitPane);
                    Main.this.validate();
                    splitPane.setDividerLocation(1.0);
                } else {
                    view.setToolTipEnabled(true);
                    Main.this.viewPanel.add(view);
                    Main.this.validate();
                }
                Main.this.updateToolTipEnabled();
                Main.this.updateMaxDepth();
                new DropTarget(view, Main.this.dropHandler);
                Main.this.repaint();
            }

            public void finished() {
                p.close();
            }
        };
        worker.start();
    }

    private JSplitPane createSplitPane(Component view) {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setLeftComponent(view);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Table", this.createTablePanel(view));
        tabbedPane.add("Info", this.createInfoPanel(view));
        splitPane.setRightComponent(tabbedPane);
        return splitPane;
    }

    private JComponent createTablePanel(Component view) {
        final JTable table = new JTable();
        TableModel tm = ((TreevizFileSystemXMLNodeInfo)this.info).getUserTable();
        table.setModel(tm);
        Methods.invokeIfExists((Object)table, "setAutoCreateRowSorter", true);
        table.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Long) {
                    value = FileSizeFormat.getInstance().format((Long)value);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    HashMap<String, TreevizFileSystemXMLNode> selectedUsers = new HashMap<String, TreevizFileSystemXMLNode>();
                    TreevizFileSystemXMLNodeInfo.InfoTableModel model = (TreevizFileSystemXMLNodeInfo.InfoTableModel)table.getModel();
                    ListSelectionModel lsm = table.getSelectionModel();
                    int n = model.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        TreevizFileSystemXMLNode user;
                        if (!lsm.isSelectedIndex(i)) continue;
                        try {
                            user = model.getRowObject((Integer)Methods.invoke(Methods.invoke(table, "getRowSorter"), "convertRowIndexToModel", i));
                        }
                        catch (NoSuchMethodException ex) {
                            user = model.getRowObject(i);
                        }
                        selectedUsers.put((String)user.getAttribute("id"), user);
                    }
                    ((TreevizFileSystemXMLNodeInfo)Main.this.info).setSelectedUsers(selectedUsers);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(0, 0));
        scrollPane.setViewportView(table);
        return scrollPane;
    }

    private JComponent createInfoPanel(Component view) {
        final JLabel infoLabel = new JLabel();
        infoLabel.setVerticalAlignment(1);
        if (view instanceof TreeView) {
            final TreeView treeView = (TreeView)((Object)view);
            view.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent evt) {
                    infoLabel.setText(treeView.getInfoText(evt));
                }
            });
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(0, 0));
        scrollPane.setViewportView(infoLabel);
        return scrollPane;
    }

    private void initComponents() {
        this.viewAsButtonGroup = new ButtonGroup();
        this.maxDepthButtonGroup = new ButtonGroup();
        this.viewPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.histogram = new JHistogram();
        this.maxDepthPanel = new JPanel();
        this.maxDepthInfinityRadio = new JRadioButton();
        this.maxDepth1Radio = new JRadioButton();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openDirectoryMenuItem = new JMenuItem();
        this.openFileMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewAsHypertreeRadio = new JRadioButtonMenuItem();
        this.viewAsSunburstRadio = new JRadioButtonMenuItem();
        this.viewAsSunrayRadio = new JRadioButtonMenuItem();
        this.viewAsIcicleRadio = new JRadioButtonMenuItem();
        this.viewAsIcerayRadio = new JRadioButtonMenuItem();
        this.viewAsCircleMapRadio = new JRadioButtonMenuItem();
        this.viewAsRectangleMapRadio = new JRadioButtonMenuItem();
        this.jSeparator1 = new JSeparator();
        this.toolTipEnabledRadio = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Tree Visualizer");
        this.viewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.viewPanel, "Center");
        this.statusPanel.setLayout(new GridBagLayout());
        this.histogram.setLayout(new FlowLayout());
        this.statusPanel.add((Component)this.histogram, new GridBagConstraints());
        this.maxDepthPanel.setLayout(new GridBagLayout());
        this.maxDepthButtonGroup.add(this.maxDepthInfinityRadio);
        this.maxDepthInfinityRadio.setText("Show full depth");
        this.maxDepthInfinityRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.maxDepthRadioPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        this.maxDepthPanel.add((Component)this.maxDepthInfinityRadio, gridBagConstraints);
        this.maxDepthButtonGroup.add(this.maxDepth1Radio);
        this.maxDepth1Radio.setText("Show current depth only");
        this.maxDepth1Radio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.maxDepthRadioPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        this.maxDepthPanel.add((Component)this.maxDepth1Radio, gridBagConstraints);
        this.statusPanel.add((Component)this.maxDepthPanel, new GridBagConstraints());
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.fileMenu.setText("File");
        this.openDirectoryMenuItem.setText("Open Directory\u2026");
        this.openDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.openDirectory(evt);
            }
        });
        this.fileMenu.add(this.openDirectoryMenuItem);
        this.openFileMenuItem.setText("Open File...");
        this.openFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.openFile(evt);
            }
        });
        this.fileMenu.add(this.openFileMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.viewAsButtonGroup.add(this.viewAsHypertreeRadio);
        this.viewAsHypertreeRadio.setSelected(true);
        this.viewAsHypertreeRadio.setText("Hyperbolic Tree");
        this.viewAsHypertreeRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsHypertreeRadio);
        this.viewAsButtonGroup.add(this.viewAsSunburstRadio);
        this.viewAsSunburstRadio.setText("Sunburst Tree");
        this.viewAsSunburstRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsSunburstRadio);
        this.viewAsButtonGroup.add(this.viewAsSunrayRadio);
        this.viewAsSunrayRadio.setText("Sunray Tree");
        this.viewAsSunrayRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsSunrayRadio);
        this.viewAsButtonGroup.add(this.viewAsIcicleRadio);
        this.viewAsIcicleRadio.setText("Icicle Tree");
        this.viewAsIcicleRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsIcicleRadio);
        this.viewAsButtonGroup.add(this.viewAsIcerayRadio);
        this.viewAsIcerayRadio.setText("Iceray Tree");
        this.viewAsIcerayRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsIcerayRadio);
        this.viewAsButtonGroup.add(this.viewAsCircleMapRadio);
        this.viewAsCircleMapRadio.setText("Circular Treemap");
        this.viewAsCircleMapRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsCircleMapRadio);
        this.viewAsButtonGroup.add(this.viewAsRectangleMapRadio);
        this.viewAsRectangleMapRadio.setText("Rectangular Treemap");
        this.viewAsRectangleMapRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Main.this.viewAsItemChanged(evt);
            }
        });
        this.viewMenu.add(this.viewAsRectangleMapRadio);
        this.viewMenu.add(this.jSeparator1);
        this.toolTipEnabledRadio.setSelected(true);
        this.toolTipEnabledRadio.setText("Show Tooltips");
        this.toolTipEnabledRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.tooltipsEnabledPerformed(evt);
            }
        });
        this.viewMenu.add(this.toolTipEnabledRadio);
        this.jMenuBar1.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.about(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void openFile(ActionEvent evt) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if (0 == this.fileChooser.showOpenDialog(this)) {
            this.openFile(this.fileChooser.getSelectedFile());
        }
    }

    private void openFile(File file) {
        this.rootFile = file;
        new Worker(){

            public Object construct() {
                if (Main.this.rootFile.getName().endsWith(".txt")) {
                    try {
                        ManyEyesTree tree = new ManyEyesTree(Main.this.rootFile);
                        return tree;
                    }
                    catch (IOException ex) {
                        return ex;
                    }
                }
                try {
                    TreevizFileSystemXMLTree tree = new TreevizFileSystemXMLTree(Main.this.rootFile);
                    return tree;
                }
                catch (IOException ex) {
                    if (ex.getMessage() != null && ex.getMessage().equals("Aborted")) {
                        return ex;
                    }
                    ex.printStackTrace();
                    try {
                        XMLTree tree = new XMLTree(Main.this.rootFile);
                        return tree;
                    }
                    catch (IOException ex2) {
                        return ex2;
                    }
                }
            }

            public void done(Object result) {
                Main.this.rootNode = ((DemoTree)result).getRoot();
                Main.this.info = ((DemoTree)result).getInfo();
                Main.this.setTitle("Tree Visualizer: " + Main.this.info.getName(new TreePath2<TreeNode>(Main.this.rootNode)));
                Main.this.updateView();
            }

            public void failed(Throwable t) {
                t.printStackTrace();
            }
        }.start();
    }

    private void about(ActionEvent evt) {
        FileSizeFormat byteFormat = FileSizeFormat.getInstance();
        JOptionPane.showMessageDialog(this, "<html>TreeViz " + Main.class.getPackage().getImplementationVersion() + "<br>" + "Copyright \u00a9 2007-2009<br>" + "Werner Randelshofer<br>" + "All rights reserved." + "<br><br>" + "Running on<br>" + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "<br>JavaVM " + System.getProperty("java.vm.version") + "<br>" + "<br>Memory " + "<br>  Max.: " + byteFormat.format(Runtime.getRuntime().maxMemory()) + ", Usage: " + byteFormat.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()), "About", -1);
    }

    private void viewAsItemChanged(ItemEvent evt) {
        String view = null;
        if (this.viewAsHypertreeRadio.isSelected()) {
            view = "hyperbolic";
        } else if (this.viewAsSunburstRadio.isSelected()) {
            view = "sunburst";
        } else if (this.viewAsSunrayRadio.isSelected()) {
            view = "sunray";
        } else if (this.viewAsIcicleRadio.isSelected()) {
            view = "icicle";
        } else if (this.viewAsIcerayRadio.isSelected()) {
            view = "iceray";
        } else if (this.viewAsCircleMapRadio.isSelected()) {
            view = "circlemap";
        } else if (this.viewAsRectangleMapRadio.isSelected()) {
            view = "rectanglemap";
        }
        if (view != null) {
            this.prefs.put("viewAs", view);
            this.updateView();
        }
    }

    private void openDirectory(ActionEvent evt) {
        if (this.directoryChooser == null) {
            this.directoryChooser = new JFileChooser();
            this.directoryChooser.setFileSelectionMode(1);
        }
        if (0 == this.directoryChooser.showOpenDialog(this)) {
            this.openDirectory(this.directoryChooser.getSelectedFile());
        }
    }

    private void tooltipsEnabledPerformed(ActionEvent evt) {
        this.prefs.putBoolean("toolTipEnabled", this.toolTipEnabledRadio.isSelected());
        this.updateToolTipEnabled();
    }

    private void maxDepthRadioPerformed(ActionEvent evt) {
        this.prefs.putInt("maxDepth", this.maxDepth1Radio.isSelected() ? 1 : Integer.MAX_VALUE);
        this.updateMaxDepth();
    }

    private void openDirectory(File dir) {
        this.rootFile = dir;
        new Worker(){

            public Object construct() {
                FileNode root = Main.this.rootFile.getParentFile() != null ? new FileNode(Main.this.rootFile.getParentFile(), Main.this.rootFile) : new FileNode(Main.this.rootFile);
                return root;
            }

            public void done(Object result) {
                Main.this.rootNode = (FileNode)result;
                Main.this.info = new FileNodeInfo();
                Main.this.setTitle("Tree Visualizer: " + Main.this.rootFile.getName());
                Main.this.updateView();
            }
        }.start();
    }

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ToolTipManager.sharedInstance().setDismissDelay(60000);
                new Main().setVisible(true);
            }
        });
    }
}

