/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.FileNode;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastModifiedWeighter
implements Weighter {
    private long min = new Date(103, 0, 1).getTime();
    private long max = new Date().getTime();
    private long median = (this.max - this.min) / 2L;
    private int[] histogram;

    @Override
    public float getWeight(TreePath2 path) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        FileNode fn = (FileNode)node;
        long lastModified = fn.getLastModified();
        return (float)(lastModified - this.min) / (float)(this.max - this.min);
    }

    public float getMedianWeight() {
        return (float)(this.median - this.min) / (float)(this.max - this.min);
    }

    @Override
    public void init(TreeNode root) {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        ArrayList<Long> dates = new ArrayList<Long>();
        this.collectDatesRecursive(root, dates);
        Collections.sort(dates);
        if (dates.size() > 0) {
            this.min = dates.get(0);
            this.max = dates.get(dates.size() - 1);
            this.median = dates.get(dates.size() / 2);
        }
        if (dates.size() > 0) {
            this.histogram = new int[256];
            this.histogramRecursive(root);
        } else {
            this.histogram = new int[1];
            this.histogram[0] = 1;
        }
    }

    private void collectDatesRecursive(TreeNode node, List<Long> dates) {
        FileNode fn = (FileNode)node;
        long lastModified = fn.getLastModified();
        dates.add(lastModified);
        for (TreeNode child : node.children()) {
            this.collectDatesRecursive(child, dates);
        }
    }

    private void histogramRecursive(TreeNode root) {
        int index;
        FileNode fn = (FileNode)root;
        long lastModified = fn.getLastModified();
        int n = index = Math.min(this.histogram.length - 1, Math.max(0, (int)((double)((lastModified - this.min) * (long)(this.histogram.length - 1)) / (double)(this.max - this.min))));
        this.histogram[n] = this.histogram[n] + 1;
        for (TreeNode child : root.children()) {
            this.histogramRecursive(child);
        }
    }

    @Override
    public int[] getHistogram() {
        return this.histogram;
    }

    @Override
    public String getMinimumWeightLabel() {
        return DateFormat.getDateTimeInstance().format(new Date(this.min));
    }

    @Override
    public String getMaximumWeightLabel() {
        return DateFormat.getDateTimeInstance().format(new Date(this.max));
    }

    @Override
    public String getHistogramLabel(int index) {
        if (this.max - this.min > 1471228928L) {
            return DateFormat.getDateInstance().format(new Date((this.max - this.min) * (long)index / (long)this.histogram.length + this.min));
        }
        return DateFormat.getDateTimeInstance().format(new Date((this.max - this.min) * (long)index / (long)this.histogram.length + this.min));
    }
}

