/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.Weighter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class JHistogram
extends JComponent {
    private Colorizer colorizer;
    private Weighter weighter;
    private int[] histogram;

    public JHistogram() {
        this.initComponents();
        this.setToolTipText("");
    }

    public void setWeighter(Weighter newValue) {
        this.weighter = newValue;
        this.histogram = (int[])(newValue != null ? this.weighter.getHistogram() : null);
    }

    public String getToolTipText(MouseEvent evt) {
        Insets insets = this.getInsets();
        Rectangle bounds = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        int index = Math.min(this.histogram.length - 1, Math.max(0, (evt.getX() - bounds.x) * this.histogram.length / bounds.width));
        return this.weighter.getHistogramLabel(index);
    }

    public Point getToolTipLocation(MouseEvent evt) {
        return new Point(evt.getX(), -12);
    }

    public void setColorizer(Colorizer newValue) {
        this.colorizer = newValue;
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        Insets insets = this.getInsets();
        if (this.histogram != null) {
            this.drawHistogram(g, new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 40);
    }

    public Dimension getMinimumSize() {
        return new Dimension(256, 40);
    }

    public void drawHistogram(Graphics2D g, Rectangle bounds) {
        if (this.colorizer != null) {
            for (int i = 0; i < bounds.width; ++i) {
                float value = (float)i / (float)bounds.width;
                int x = bounds.x + i;
                g.setColor(this.colorizer.get(value));
                g.fillRect(x, bounds.y, 1, bounds.height);
            }
        }
        int maxCount = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            maxCount = Math.max(maxCount, this.histogram[i]);
        }
        float scaleFactor = (float)bounds.height / (float)maxCount;
        g.setColor(Color.black);
        for (int i = 0; i < this.histogram.length; ++i) {
            float value = (float)i / (float)this.histogram.length;
            int x = (int)((float)bounds.x + (float)bounds.width * value);
            int height = (int)Math.ceil(scaleFactor * (float)this.histogram[i]);
            g.fillRect(x, bounds.y + bounds.height - height, 1, height);
        }
    }

    private void initComponents() {
    }
}

